/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.dom.converters;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.Forward;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.dom.converters.NameConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ForwardNameConverter
extends NameConverter<Forward> {
    public ForwardNameConverter() {
        super("Forward");
    }

    @Override
    protected GenericDomValue<PsiClass> getClassElement(Forward parent) {
        return parent.getClassName();
    }

    @Override
    protected List<Forward> getSiblings(Forward parent) {
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends String> getVariants(ConvertContext convertContext) {
        DomElement parent;
        String path;
        String[] strings;
        LinkedHashSet<String> result = new LinkedHashSet<String>(super.getVariants(convertContext));
        Forward element = (Forward)convertContext.getInvocationElement().getParent();
        assert (element != null);
        PathReference value = (PathReference)element.getPath().getValue();
        if (value != null && StringUtil.isNotEmpty((String)value.getPath()) && (strings = (path = value.getTrimmedPath()).split("/")).length > 0) {
            String fileName = strings[strings.length - 1];
            fileName = FileUtil.getNameWithoutExtension((String)fileName);
            fileName = StringUtil.decapitalize((String)fileName);
            result.add(fileName);
        }
        if ((parent = element.getParent()) instanceof Action) {
            StrutsConfig config = StrutsManager.getInstance().getContext(element);
            HashSet<String> variants = new HashSet<String>();
            List<Action> actions = config.getActionMappings().getActions();
            for (Action action : actions) {
                List<Forward> forwards = action.getForwards();
                for (Forward forward : forwards) {
                    String forwardName = forward.getName().getStringValue();
                    if (!StringUtil.isNotEmpty((String)forwardName)) continue;
                    variants.add(forwardName);
                }
            }
            for (Forward forward : ((Action)parent).getForwards()) {
                variants.remove(forward.getName().getStringValue());
            }
            result.addAll(variants);
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            ForwardNameConverter.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/dom/converters/ForwardNameConverter", "getVariants"));
    }
}

