/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.ActionMappings;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.dom.FormBeans;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NameConverter<T extends DomElement>
implements CustomReferenceConverter<String> {
    private final String myClassPostfix;

    public NameConverter(@NonNls String classPostfix) {
        this.myClassPostfix = classPostfix;
    }

    protected abstract GenericDomValue<PsiClass> getClassElement(T var1);

    @Nullable
    protected abstract List<T> getSiblings(T var1);

    protected void preprocess(List<String> variants) {
    }

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        GenericDomValue<PsiClass> classElement = this.getClassElement(parent);
        PsiClass psiClass = (PsiClass)classElement.getValue();
        if (psiClass != null) {
            ArrayList<String> variants = new ArrayList<String>();
            String className = psiClass.getName();
            if (className != null && className.endsWith(this.myClassPostfix)) {
                String s = className.substring(0, className.length() - this.myClassPostfix.length());
                s = StringUtil.decapitalize((String)s);
                variants.add(s);
            } else {
                Project project = psiClass.getProject();
                PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)psiClass);
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType);
                ContainerUtil.addAll(variants, (Object[])info.names);
            }
            this.preprocess(variants);
            List<DomElement> list = this.getSiblings(parent);
            if (list != null) {
                for (int i = 0; i < variants.size(); ++i) {
                    String name = variants.get(i);
                    int iter = 0;
                    while (DomUtil.findByName(list, (String)name) != null) {
                        name = variants.get(i) + ++iter;
                    }
                    variants.set(i, name);
                }
            }
            ArrayList<String> arrayList = variants;
            if (arrayList == null) {
                NameConverter.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            NameConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<String> genericDomValue, PsiElement element, final ConvertContext context) {
        PsiReferenceBase<PsiElement> ref = new PsiReferenceBase<PsiElement>(element){

            public PsiElement resolve() {
                return genericDomValue.getParent().getXmlTag();
            }

            public boolean isSoft() {
                return true;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return this.getElement();
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = NameConverter.this.getVariants(context).toArray();
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/dom/converters/NameConverter$1", "getVariants"));
            }
        };
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            NameConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/struts/dom/converters/NameConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ForForm
    extends NameConverter<FormBean> {
        public ForForm() {
            super("Form");
        }

        @Override
        protected GenericDomValue<PsiClass> getClassElement(FormBean parent) {
            return parent.getType();
        }

        @Override
        @Nullable
        protected List<FormBean> getSiblings(FormBean parent) {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel((PsiElement)parent.getXmlTag());
            if (model == null) {
                DomElement element = parent.getParent();
                assert (element != null);
                return ((FormBeans)element).getFormBeans();
            }
            return model.getFormBeans();
        }
    }

    public static class ForAction
    extends NameConverter<Action> {
        public ForAction() {
            super("Action");
        }

        @Override
        protected void preprocess(List<String> variants) {
            for (int i = 0; i < variants.size(); ++i) {
                variants.set(i, "/" + variants.get(i));
            }
        }

        @Override
        protected GenericDomValue<PsiClass> getClassElement(Action parent) {
            return parent.getType();
        }

        @Override
        @Nullable
        protected List<Action> getSiblings(Action parent) {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel((PsiElement)parent.getXmlTag());
            if (model == null) {
                DomElement element = parent.getParent();
                assert (element != null);
                return ((ActionMappings)element).getActions();
            }
            return model.getActions();
        }
    }
}

