/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;

public final class AnnotationsUtils {
    public static final FqName JS_MODULE_ANNOTATION = new FqName("kotlin.js.JsModule");
    private static final FqName JS_NON_MODULE_ANNOTATION = new FqName("kotlin.js.JsNonModule");
    public static final FqName JS_QUALIFIER_ANNOTATION = new FqName("kotlin.js.JsQualifier");

    private AnnotationsUtils() {
    }

    public static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation2);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value = constant.getValue();
        assert (value instanceof String) : "Native function annotation should have one String parameter";
        return (String)value;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation2)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation2);
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor descriptor2) {
        String defaultJsName = AnnotationsUtils.getJsName(descriptor2);
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.Companion.getWITH_CUSTOM_NAME()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, annotation2);
            if (name == null) {
                name = defaultJsName;
            }
            return name != null ? name : descriptor2.getName().asString();
        }
        if (defaultJsName == null && AnnotationsUtils.isEffectivelyExternalMember(descriptor2)) {
            return descriptor2.getName().asString();
        }
        return defaultJsName;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2.getFqName());
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        AnnotationWithTarget annotationWithTarget = Annotations.Companion.findAnyAnnotation(descriptor2.getAnnotations(), fqName2);
        return annotationWithTarget != null ? annotationWithTarget.getAnnotation() : null;
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor2) {
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.NATIVE) || AnnotationsUtils.isEffectivelyExternalMember(descriptor2)) {
            return true;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyAccessorDescriptor accessor = (PropertyAccessorDescriptor)descriptor2;
            return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)accessor.getCorrespondingProperty(), PredefinedAnnotation.NATIVE);
        }
        return false;
    }

    public static boolean isNativeInterface(@NotNull DeclarationDescriptor descriptor2) {
        return AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isInterface(descriptor2);
    }

    private static boolean isEffectivelyExternalMember(@NotNull DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor2) {
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.LIBRARY);
    }

    @Nullable
    public static String getJsName(@NotNull DeclarationDescriptor descriptor2) {
        AnnotationDescriptor annotation2 = AnnotationsUtils.getJsNameAnnotation(descriptor2);
        if (annotation2 == null || annotation2.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> value = annotation2.getAllValueArguments().values().iterator().next();
        if (value == null) {
            return null;
        }
        Object result2 = value.getValue();
        if (!(result2 instanceof String)) {
            return null;
        }
        return (String)result2;
    }

    @Nullable
    public static AnnotationDescriptor getJsNameAnnotation(@NotNull DeclarationDescriptor descriptor2) {
        return AnnotationsUtils.getAnnotationByName(descriptor2, new FqName("kotlin.js.JsName"));
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) {
            return true;
        }
        if (AnnotationsUtils.isEffectivelyExternalMember(descriptor2)) {
            return true;
        }
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2.getFqName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        if (AnnotationsUtils.getAnnotationByName(descriptor2, fqName2) != null) {
            return true;
        }
        ClassDescriptor containingClass = DescriptorUtils.getContainingClass(descriptor2);
        return containingClass != null && AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)containingClass, fqName2);
    }

    public static boolean hasJsNameInAccessors(@NotNull PropertyDescriptor property) {
        for (PropertyAccessorDescriptor accessor : property.getAccessors()) {
            if (AnnotationsUtils.getJsName(accessor) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getModuleName(@NotNull DeclarationDescriptor declaration) {
        AnnotationDescriptor annotation2 = declaration.getAnnotations().findAnnotation(JS_MODULE_ANNOTATION);
        return annotation2 != null ? AnnotationsUtils.extractSingleStringArgument(annotation2) : null;
    }

    @Nullable
    public static String getFileModuleName(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration) {
        return AnnotationsUtils.getSingleStringAnnotationArgument(bindingContext, declaration, JS_MODULE_ANNOTATION);
    }

    @Nullable
    public static String getFileQualifier(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration) {
        return AnnotationsUtils.getSingleStringAnnotationArgument(bindingContext, declaration, JS_QUALIFIER_ANNOTATION);
    }

    @Nullable
    private static String getSingleStringAnnotationArgument(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration, @NotNull FqName annotationFqName) {
        for (AnnotationDescriptor annotation2 : AnnotationsUtils.getContainingFileAnnotations(bindingContext, declaration)) {
            if (!annotationFqName.equals(annotation2.getFqName())) continue;
            return AnnotationsUtils.extractSingleStringArgument(annotation2);
        }
        return null;
    }

    public static boolean isNonModule(@NotNull DeclarationDescriptor declaration) {
        return declaration.getAnnotations().findAnnotation(JS_NON_MODULE_ANNOTATION) != null;
    }

    public static boolean isFromNonModuleFile(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration) {
        return CollectionsKt.any(AnnotationsUtils.getContainingFileAnnotations(bindingContext, declaration), annotation2 -> JS_NON_MODULE_ANNOTATION.equals(annotation2.getFqName()));
    }

    @Nullable
    private static String extractSingleStringArgument(@NotNull AnnotationDescriptor annotation2) {
        if (annotation2.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> importValue = annotation2.getAllValueArguments().values().iterator().next();
        if (importValue == null) {
            return null;
        }
        if (!(importValue.getValue() instanceof String)) {
            return null;
        }
        return (String)importValue.getValue();
    }

    @NotNull
    public static List<AnnotationDescriptor> getContainingFileAnnotations(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor2) {
        PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
        if (containingPackage instanceof KotlinJavascriptPackageFragment) {
            return ((KotlinJavascriptPackageFragment)containingPackage).getContainingFileAnnotations(descriptor2);
        }
        KtFile kotlinFile = AnnotationsUtils.getFile(descriptor2);
        if (kotlinFile != null) {
            ArrayList<AnnotationDescriptor> annotations2 = new ArrayList<AnnotationDescriptor>();
            for (KtAnnotationEntry psiAnnotation : kotlinFile.getAnnotationEntries()) {
                AnnotationDescriptor annotation2 = bindingContext.get(BindingContext.ANNOTATION, psiAnnotation);
                if (annotation2 == null) continue;
                annotations2.add(annotation2);
            }
            return annotations2;
        }
        return Collections.emptyList();
    }

    @Nullable
    private static KtFile getFile(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        SourceFile file = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile();
        if (!(file instanceof PsiSourceFile)) {
            return null;
        }
        PsiFile psiFile = ((PsiSourceFile)file).getPsiFile();
        if (!(psiFile instanceof KtFile)) {
            return null;
        }
        return (KtFile)psiFile;
    }
}

