/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.typedHandlers;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.coldFusion.UI.editorActions.matchers.CfmlBraceMatcher;
import com.intellij.coldFusion.UI.editorActions.typedHandlers.DocumentUtils;
import com.intellij.coldFusion.UI.editorActions.utils.CfmlEditorUtil;
import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;

public class CfmlTypedHandler
extends TypedHandlerDelegate {
    static final boolean ourEnableDoublePoundInsertion = SystemProperties.getBooleanProperty((String)"idea.cfml.insert.pair.pound", (boolean)true);

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        PsiFile cfmlFile = file.getViewProvider().getPsi((Language)CfmlLanguage.INSTANCE);
        if (CfmlTypedHandler.isNotCfmlFile(cfmlFile, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (charTyped == '/') {
            CfmlUtil.showCompletion(editor);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        PsiFile cfmlFile = file.getViewProvider().getPsi((Language)CfmlLanguage.INSTANCE);
        if (CfmlTypedHandler.isNotCfmlFile(cfmlFile, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor.getCaretModel().getOffset();
        if (c == '{') {
            CfmlBraceMatcher braceMatcher = new CfmlBraceMatcher();
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (!braceMatcher.isLBraceToken(iterator, editor.getDocument().getCharsSequence(), fileType)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}", (boolean)true, (int)0);
            }
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '#') {
            if (ourEnableDoublePoundInsertion && CfmlEditorUtil.countSharpsBalance(editor) == 0) {
                char charAtOffset = DocumentUtils.getCharAt(editor.getDocument(), offset);
                if (charAtOffset == '#') {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                    return TypedHandlerDelegate.Result.STOP;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"#", (boolean)true, (int)0);
            }
        } else if (c == '>') {
            if (((EditorEx)editor).getHighlighter().createIterator(editor.getCaretModel().getOffset()).getTokenType() == CfmlTokenTypes.COMMENT || ((EditorEx)editor).getHighlighter().createIterator(editor.getCaretModel().getOffset()).getTokenType().getLanguage() != CfmlLanguage.INSTANCE) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            CfmlTypedHandler.insertCloseTagIfNeeded(editor, cfmlFile, project);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static boolean insertCloseTagIfNeeded(Editor editor, PsiFile file, Project project) {
        PsiElement tagElement;
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        int offset = editor.getCaretModel().getOffset();
        documentManager.commitDocument(document);
        char charAtOffset = DocumentUtils.getCharAt(document, offset);
        if (charAtOffset != '>') {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)true, (int)0);
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        if (DocumentUtils.getCharAt(document, ++offset - 2) == '/') {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 2);
        while (!iterator.atEnd() && !iterator.getTokenType().equals(CfmlTokenTypes.CF_TAG_NAME)) {
            if (CfmlUtil.isControlToken(iterator.getTokenType())) {
                return false;
            }
            iterator.retreat();
        }
        if (!iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && iterator.getTokenType().equals(CfmlTokenTypes.LSLASH_ANGLEBRACKET)) {
                return false;
            }
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        String tagName = document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()).toString();
        if (CfmlUtil.isSingleCfmlTag(tagName, project) || CfmlUtil.isUserDefined(tagName)) {
            return false;
        }
        for (tagElement = file.findElementAt(iterator.getStart()); tagElement != null && !(tagElement instanceof CfmlTag); tagElement = tagElement.getParent()) {
        }
        if (tagElement == null) {
            return false;
        }
        boolean doInsertion = false;
        if (tagElement.getLastChild() instanceof PsiErrorElement) {
            doInsertion = true;
        } else {
            iterator = ((EditorEx)editor).getHighlighter().createIterator(0);
            while (!iterator.atEnd() && iterator.getStart() < offset) {
                String currentTagName;
                if (iterator.getTokenType() == CfmlTokenTypes.CF_TAG_NAME && tagName.equals(currentTagName = document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()).toString())) {
                    PsiElement currentTagElement = file.findElementAt(iterator.getStart());
                    if ((currentTagElement = PsiTreeUtil.getParentOfType((PsiElement)currentTagElement, CfmlTag.class)).getLastChild() instanceof PsiErrorElement) {
                        doInsertion = true;
                        break;
                    }
                }
                iterator.advance();
            }
        }
        String tagNameFromPsi = ((CfmlTag)tagElement).getTagName();
        if (doInsertion && CfmlUtil.isEndTagRequired(tagNameFromPsi, project)) {
            if (!Comparing.equal((String)tagNameFromPsi, (String)tagName, (boolean)false)) {
                tagName = tagNameFromPsi;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + tagName + ">"), (boolean)true, (int)0);
            return true;
        }
        return false;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CfmlTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CfmlTypedHandler.$$$reportNull$$$0(1);
        }
        if (CfmlTypedHandler.isNotCfmlFile(file, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    static boolean isNotCfmlFile(PsiFile file, Editor editor) {
        return !(file instanceof CfmlFile) || editor.getCaretModel().getOffset() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlTypedHandler";
        objectArray[2] = "charTyped";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

