/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.inspections;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CfmlFileReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CfmlFileReferenceInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement tagParent = PsiTreeUtil.getParentOfType((PsiElement)element, CfmlTag.class);
                if (element.getNode().getElementType() == CfmlTokenTypes.STRING_TEXT) {
                    if (tagParent == null || !((CfmlTag)tagParent).getTagName().equalsIgnoreCase("cfinclude") && !((CfmlTag)tagParent).getTagName().equalsIgnoreCase("cfmodule")) {
                        ASTNode superParentNode;
                        PsiElement superParent = element.getParent() != null ? element.getParent().getParent() : null;
                        ASTNode aSTNode = superParentNode = superParent != null ? superParent.getNode() : null;
                        if (superParentNode == null || superParentNode.getElementType() != CfmlElementTypes.INCLUDEEXPRESSION) {
                            return;
                        }
                    }
                    PsiReference[] refs = element.getParent().getReferences();
                    int refsLength = refs.length;
                    for (int i = 0; i < refsLength; ++i) {
                        LocalQuickFix[] localQuickFixArray;
                        PsiElement target;
                        PsiReference ref = refs[i];
                        if (!(ref instanceof FileReference) || ref.resolve() != null) continue;
                        PsiDirectory dir = i > 0 ? ((target = refs[i - 1].resolve()) instanceof PsiDirectory ? (PsiDirectory)target : null) : element.getContainingFile().getParent();
                        PsiElement psiElement = ref.getElement();
                        TextRange textRange = ref.getRangeInElement();
                        String string = isOnTheFly ? "Path '" + ref.getCanonicalText() + "' not found" : "Path not found";
                        if (isOnTheFly && dir != null) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = new CreateFileFix(i < refs.length - 1, ref.getCanonicalText(), dir);
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        holder.registerProblem(psiElement, textRange, string, localQuickFixArray);
                        break;
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            CfmlFileReferenceInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CfmlBundle.message("cfml.file.references.inspection", new Object[0]);
        if (string == null) {
            CfmlFileReferenceInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/UI/inspections/CfmlFileReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/UI/inspections/CfmlFileReferenceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

