/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.files;

import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlImplicitVariable;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.impl.CfmlTagScriptImpl;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlFile
extends PsiFileBase {
    private final CachedValue<Map<String, CfmlImplicitVariable>> myImplicitVars;
    @NonNls
    public static final String CFMLVARIABLE_MARKER = "@cfmlvariable ";
    @NonNls
    public static final String CFMLJAVALOADER_MARKER = "@javaloader ";
    @NonNls
    public static final Pattern LOADER_DECL_PATTERN_TEMP = Pattern.compile("<!---[\\s]*@javaloader [\\s]*name=\"([^\"]+)\".*[\\s]*(loadPaths=\"([^\"]*)\")[\\s]*--->[\\s]*");
    @NonNls
    public static final Pattern IMPLICIT_VAR_DECL_PATTERN_TEMP = Pattern.compile("<!---[\\s]*@cfmlvariable [\\s]*name=\"([^\"]+)\"[\\s]*type=\"([^\"]*)\"[\\s]*--->[\\s]*");

    CachedValueProvider<Map<String, CfmlImplicitVariable>> createImplicitVarsProvider() {
        return () -> {
            THashMap result = new THashMap();
            this.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Map)result){
                final /* synthetic */ Map val$result;
                {
                    this.val$result = map;
                }

                public void visitComment(PsiComment comment) {
                    String text = comment.getText();
                    String[] nameAndType = CfmlFile.findVariableNameAndType(text);
                    if (nameAndType == null) {
                        return;
                    }
                    CfmlImplicitVariable var = (CfmlImplicitVariable)ContainerUtil.getOrCreate((Map)this.val$result, (Object)nameAndType[0], () -> new CfmlImplicitVariable((PsiFile)CfmlFile.this, comment, nameAndType[0]));
                    var.setType(nameAndType[1]);
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this});
        };
    }

    public CfmlFile(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            CfmlFile.$$$reportNull$$$0(0);
        }
        super(viewProvider, language);
        this.myImplicitVars = CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue(this.createImplicitVarsProvider(), false);
    }

    @NotNull
    public FileType getFileType() {
        CfmlFileType cfmlFileType = CfmlFileType.INSTANCE;
        if (cfmlFileType == null) {
            CfmlFile.$$$reportNull$$$0(1);
        }
        return cfmlFileType;
    }

    @NotNull
    public String getPresentableName() {
        String string = "CfmlFile:" + this.getName();
        if (string == null) {
            CfmlFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            CfmlFile.$$$reportNull$$$0(3);
        }
        if (state == null) {
            CfmlFile.$$$reportNull$$$0(4);
        }
        if (place == null) {
            CfmlFile.$$$reportNull$$$0(5);
        }
        if (!this.processExportableDeclarations(processor, state)) {
            return false;
        }
        return CfmlPsiUtil.processDeclarations(processor, state, lastParent, (PsiElement)this);
    }

    private boolean processExportableDeclarations(PsiScopeProcessor processor, ResolveState state) {
        for (CfmlImplicitVariable var : ((Map)this.myImplicitVars.getValue()).values()) {
            if (processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String[] findVariableNameAndType(String text) {
        Matcher matcher = IMPLICIT_VAR_DECL_PATTERN_TEMP.matcher(text);
        Matcher javaLoaderMatcher = LOADER_DECL_PATTERN_TEMP.matcher(text);
        if (!matcher.matches()) {
            if (!javaLoaderMatcher.matches()) {
                return null;
            }
            return new String[]{javaLoaderMatcher.group(1), "javaloader"};
        }
        return new String[]{matcher.group(1), matcher.group(2)};
    }

    @Nullable
    public CfmlImplicitVariable findImplicitVariable(String name) {
        return (CfmlImplicitVariable)((Map)this.myImplicitVars.getValue()).get(name);
    }

    public Collection<CfmlFunction> getGlobalFunctions() {
        final LinkedList<CfmlFunction> result = new LinkedList<CfmlFunction>();
        this.accept(new CfmlRecursiveElementVisitor(){

            @Override
            public void visitCfmlFunction(CfmlFunction function) {
                result.add(function);
            }

            @Override
            public void visitCfmlComponent(CfmlComponent component) {
            }

            @Override
            public void visitElement(PsiElement element) {
                if (element instanceof CfmlFile || element instanceof CfmlTag) {
                    super.visitElement(element);
                }
            }
        });
        return result;
    }

    @Nullable
    public CfmlComponent getComponentDefinition() {
        final Ref ref = new Ref(null);
        this.accept(new CfmlRecursiveElementVisitor(){

            @Override
            public void visitCfmlFunction(CfmlFunction function) {
            }

            @Override
            public void visitCfmlComponent(CfmlComponent component) {
                ref.set((Object)component);
            }

            @Override
            public void visitCfmlTag(CfmlTag tag) {
                if (tag instanceof CfmlTagScriptImpl) {
                    super.visitCfmlTag(tag);
                }
            }

            @Override
            public void visitElement(PsiElement element) {
                if (element instanceof CfmlFile || element instanceof CfmlTagScriptImpl) {
                    super.visitElement(element);
                }
            }
        });
        return (CfmlComponent)ref.get();
    }

    public String getComponentQualifiedName(@NotNull String componentName) {
        CfmlImport[] childrenByClass;
        if (componentName == null) {
            CfmlFile.$$$reportNull$$$0(6);
        }
        for (CfmlImport importStatement : childrenByClass = (CfmlImport[])this.findChildrenByClass(CfmlImport.class)) {
            if (!importStatement.isImported(componentName)) continue;
            String importString = importStatement.getImportString();
            return importString != null ? importString : "";
        }
        return componentName;
    }

    public Collection<String> getImportStrings() {
        CfmlImport[] childrenByClass;
        HashSet result = new HashSet();
        for (CfmlImport importStatement : childrenByClass = (CfmlImport[])this.findChildrenByClass(CfmlImport.class)) {
            String importString = importStatement.getImportString();
            if (importString == null) continue;
            result.add(importString);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/files/CfmlFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/files/CfmlFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComponentQualifiedName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

