/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.UI.config.CfmlMappingsConfig;
import com.intellij.coldFusion.UI.config.CfmlProjectConfiguration;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CfmlFileReferenceSet
extends FileReferenceSet
implements PlatformIcons {
    public CfmlFileReferenceSet(CfmlCompositeElement element, int shift) {
        super(CfmlFileReferenceSet.stripText(element.getText()), (PsiElement)element, shift, null, SystemInfo.isFileSystemCaseSensitive);
    }

    private static String stripText(String text) {
        int i1 = text.indexOf(34) == -1 ? Integer.MAX_VALUE : text.indexOf(34);
        int i2 = text.indexOf(39) == -1 ? Integer.MAX_VALUE : text.indexOf(39);
        int quoteCharacter = i1 < i2 ? 34 : 39;
        int i = Math.min(i1, i2);
        if (i == Integer.MAX_VALUE) {
            return text;
        }
        int lastIndex = text.lastIndexOf(quoteCharacter);
        if (lastIndex == i) {
            return text;
        }
        return text.substring(i + 1, lastIndex);
    }

    public CfmlFileReference createFileReference(TextRange range, int index, String text) {
        return new CfmlFileReference(this, range, index, text);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiReference firstFileReference;
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        if ((StringUtil.startsWithChar((CharSequence)this.getPathString(), (char)'/') || StringUtil.startsWithChar((CharSequence)this.getPathString(), (char)'\\')) && (firstFileReference = this.getElement().getReferences()[0]) instanceof FileReference) {
            CfmlProjectConfiguration.State state = CfmlProjectConfiguration.getInstance(this.getElement().getProject()).getState();
            if (state == null) {
                Collection collection = super.computeDefaultContexts();
                if (collection == null) {
                    CfmlFileReferenceSet.$$$reportNull$$$0(0);
                }
                return collection;
            }
            CfmlMappingsConfig mappingsConfig = state.getMapps();
            Map<String, String> mapDir = mappingsConfig.getServerMappings();
            for (String value : mapDir.keySet()) {
                String path = mapDir.get(value);
                VirtualFile dir = CfmlFileReferenceSet.findFile(path);
                if (dir == null) continue;
                PsiDirectory psiDirectory = this.getElement().getManager().findDirectory(dir);
                contexts.add((PsiFileSystemItem)psiDirectory);
            }
        }
        contexts.addAll(super.computeDefaultContexts());
        ArrayList<PsiFileSystemItem> arrayList = contexts;
        if (arrayList == null) {
            CfmlFileReferenceSet.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static VirtualFile findFile(String path) {
        VirtualFile dir = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        if (dir == null) {
            dir = VirtualFileManager.getInstance().findFileByUrl(path);
        }
        return dir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlFileReferenceSet", "computeDefaultContexts"));
    }

    private static class CfmlFileReference
    extends FileReference {
        public CfmlFileReference(CfmlFileReferenceSet set, TextRange range, int index, String text) {
            super((FileReferenceSet)set, range, index, text);
        }

        protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
            CfmlProjectConfiguration.State state;
            if (text == null) {
                CfmlFileReference.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CfmlFileReference.$$$reportNull$$$0(1);
            }
            if ((state = CfmlProjectConfiguration.getInstance(this.getElement().getProject()).getState()) == null) {
                super.innerResolveInContext(text, context, result, caseSensitive);
                return;
            }
            CfmlMappingsConfig mappingsConfig = state.getMapps();
            Map<String, String> mapDir = mappingsConfig.getServerMappings();
            int len = this.getFileReferenceSet().getAllReferences().length;
            for (String logicalPath : mapDir.keySet()) {
                String updateLogicalPath = logicalPath.replaceAll("\\\\", "/");
                String textInFile = this.getFileReferenceSet().getReference(0).getText();
                if (!updateLogicalPath.contains(text) || !StringUtil.startsWithChar((CharSequence)updateLogicalPath, (char)'/')) continue;
                for (int i = 0; updateLogicalPath.contains(textInFile) && i < len; ++i) {
                    if (updateLogicalPath.substring(1).equalsIgnoreCase(textInFile)) {
                        VirtualFile dir;
                        String filePathWithMap = mapDir.get(logicalPath);
                        VirtualFile virtualFile = dir = filePathWithMap != null ? CfmlFileReferenceSet.findFile(filePathWithMap) : null;
                        if (dir != null) {
                            PsiDirectory child = context.getManager().findDirectory(dir);
                            result.add((ResolveResult)new PsiElementResolveResult((PsiElement)CfmlFileReference.getOriginalFile((PsiFileSystemItem)child)));
                        }
                    }
                    if (i >= len - 1) continue;
                    textInFile = textInFile + "/" + this.getFileReferenceSet().getReference(i + 1).getText();
                }
            }
            if (this.getIndex() == 0 && this.getElement().getNode().getText().startsWith("/")) {
                return;
            }
            super.innerResolveInContext(text, context, result, caseSensitive);
        }

        @NotNull
        public Object[] getVariants() {
            LinkedList<Object> variants = new LinkedList<Object>();
            String text = this.getElement().getNode().getText();
            if (StringUtil.startsWithChar((CharSequence)text, (char)'\"') && text.endsWith("\"")) {
                text = text.substring(1, text.length() - 1);
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'/')) {
                CfmlProjectConfiguration.State state = CfmlProjectConfiguration.getInstance(this.getElement().getProject()).getState();
                CfmlMappingsConfig mappings = state != null ? state.getMapps().clone() : new CfmlMappingsConfig();
                for (String value : mappings.getServerMappings().keySet()) {
                    if (this.getIndex() != 0 || !value.startsWith("/") && !value.startsWith("\\")) continue;
                    variants.add(LookupElementBuilder.create((Object)value, (String)value.replace('\\', '/').substring(1)).withCaseSensitivity(false).withIcon(PlatformIcons.FOLDER_ICON));
                }
                if (this.getIndex() == 0) {
                    Object[] objectArray = variants.toArray();
                    if (objectArray == null) {
                        CfmlFileReference.$$$reportNull$$$0(2);
                    }
                    return objectArray;
                }
            }
            variants.addAll(Arrays.asList(super.getVariants()));
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                CfmlFileReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coldFusion/model/psi/CfmlFileReferenceSet$CfmlFileReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlFileReferenceSet$CfmlFileReference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolveInContext";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

