/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlExpressionTypeCalculator;
import com.intellij.coldFusion.model.psi.CfmlOperatorTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CfmlOperatorExpression
extends CfmlCompositeElement
implements CfmlExpression {
    private final boolean myBinary;

    public CfmlOperatorExpression(@NotNull ASTNode node, boolean binary) {
        if (node == null) {
            CfmlOperatorExpression.$$$reportNull$$$0(0);
        }
        super(node);
        this.myBinary = binary;
    }

    @Override
    public PsiType getPsiType() {
        CfmlExpressionTypeCalculator typeCalculator = this.getOperationSign().getTypeCalculator();
        CfmlExpression operand1 = this.getOperand1();
        if (operand1 == null) {
            return null;
        }
        if (!this.myBinary) {
            return typeCalculator.calculateUnary(operand1);
        }
        CfmlExpression operand2 = this.getOperand2();
        if (operand2 == null) {
            return null;
        }
        return typeCalculator.calculateBinary(operand1, operand2);
    }

    @NotNull
    private CfmlOperatorTokenType getOperationSign() {
        ASTNode operationNode = this.getNode().findChildByType(CfscriptTokenTypes.OPERATIONS);
        assert (operationNode != null) : this.getText();
        IElementType tokenType = operationNode.getElementType();
        assert (tokenType instanceof CfmlOperatorTokenType) : this.getText();
        CfmlOperatorTokenType cfmlOperatorTokenType = (CfmlOperatorTokenType)tokenType;
        if (cfmlOperatorTokenType == null) {
            CfmlOperatorExpression.$$$reportNull$$$0(1);
        }
        return cfmlOperatorTokenType;
    }

    private CfmlExpression getOperand1() {
        return (CfmlExpression)this.findChildByClass(CfmlExpression.class);
    }

    private CfmlExpression getOperand2() {
        PsiElement second;
        CfmlExpression first = this.getOperand1();
        if (first == null) {
            return null;
        }
        for (second = first.getNextSibling(); second != null && !(second instanceof CfmlExpression); second = second.getNextSibling()) {
        }
        return (CfmlExpression)second;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/psi/CfmlOperatorExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlOperatorExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

