/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.stubs;

import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentStub;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentStubImpl;
import com.intellij.coldFusion.model.psi.stubs.CfmlInheritanceIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlInterfaceIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementType;
import com.intellij.lang.Language;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CfmlComponentElementType
extends CfmlStubElementType<CfmlComponentStub, CfmlComponent> {
    public CfmlComponentElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            CfmlComponentElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
    }

    @NotNull
    public CfmlComponentStub createStub(@NotNull CfmlComponent psi, StubElement parentStub) {
        if (psi == null) {
            CfmlComponentElementType.$$$reportNull$$$0(1);
        }
        CfmlComponentStubImpl cfmlComponentStubImpl = new CfmlComponentStubImpl(parentStub, this, psi.getName(), psi.isInterface(), psi.getSuperName(), psi.getInterfaceNames());
        if (cfmlComponentStubImpl == null) {
            CfmlComponentElementType.$$$reportNull$$$0(2);
        }
        return cfmlComponentStubImpl;
    }

    public void serialize(@NotNull CfmlComponentStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            CfmlComponentElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            CfmlComponentElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isInterface());
        dataStream.writeName(stub.getSuperclass());
        dataStream.writeByte(stub.getInterfaces().length);
        for (String name : stub.getInterfaces()) {
            dataStream.writeName(name);
        }
    }

    @NotNull
    public CfmlComponentStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            CfmlComponentElementType.$$$reportNull$$$0(5);
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        boolean isInterface = dataStream.readBoolean();
        String superclass = StringRef.toString((StringRef)dataStream.readName());
        int supersNumber = dataStream.readByte();
        String[] interfaces = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            interfaces[i] = StringRef.toString((StringRef)dataStream.readName());
        }
        CfmlComponentStubImpl cfmlComponentStubImpl = new CfmlComponentStubImpl(parentStub, this, name, isInterface, superclass, interfaces);
        if (cfmlComponentStubImpl == null) {
            CfmlComponentElementType.$$$reportNull$$$0(6);
        }
        return cfmlComponentStubImpl;
    }

    @Override
    public void indexStub(@NotNull CfmlComponentStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            CfmlComponentElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            CfmlComponentElementType.$$$reportNull$$$0(8);
        }
        super.indexStub(stub, sink);
        String shortName = stub.getName();
        if (shortName != null) {
            if (stub.isInterface()) {
                sink.occurrence(CfmlInterfaceIndex.KEY, (Object)shortName.toLowerCase());
            } else {
                sink.occurrence(CfmlComponentIndex.KEY, (Object)shortName.toLowerCase());
            }
        }
        if (stub.getSuperclass() != null) {
            sink.occurrence(CfmlInheritanceIndex.KEY, (Object)stub.getSuperclass().toLowerCase());
        }
        for (String superName : stub.getInterfaces()) {
            sink.occurrence(CfmlInheritanceIndex.KEY, (Object)superName.toLowerCase());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/psi/stubs/CfmlComponentElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

