/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.mxunit;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.UI.runner.CfmlRunConfiguration;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.mxunit.CfmlStackTraceFilterProvider;
import com.intellij.coldFusion.mxunit.CfmlUnitConsoleProperties;
import com.intellij.coldFusion.mxunit.CfmlUnitRemoteTestsRunner;
import com.intellij.coldFusion.mxunit.CfmlUnitRunConfigurationForm;
import com.intellij.coldFusion.mxunit.CfmlUnitRunnerParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.OutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CfmlUnitRunConfiguration
extends LocatableConfigurationBase {
    private CfmlUnitRunnerParameters myRunnerParameters = this.createRunnerParametersInstance();

    protected CfmlUnitRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        CfmlUnitRunConfigurationForm cfmlUnitRunConfigurationForm = new CfmlUnitRunConfigurationForm(this.getProject());
        if (cfmlUnitRunConfigurationForm == null) {
            CfmlUnitRunConfiguration.$$$reportNull$$$0(0);
        }
        return cfmlUnitRunConfigurationForm;
    }

    public RunProfileState getState(@NotNull Executor executor, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            CfmlUnitRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CfmlUnitRunConfiguration.$$$reportNull$$$0(2);
        }
        return new RunProfileState(){

            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (runner == null) {
                    1.$$$reportNull$$$0(0);
                }
                MyProcessHandler processHandler = new MyProcessHandler();
                ConsoleView console = CfmlUnitRunConfiguration.this.createConsole(CfmlUnitRunConfiguration.this.getProject(), processHandler, env, executor);
                console.addMessageFilter((Filter)new CfmlStackTraceFilterProvider(CfmlUnitRunConfiguration.this.getProject()));
                CfmlUnitRunConfiguration.this.runTests(processHandler);
                return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/coldFusion/mxunit/CfmlUnitRunConfiguration$1", "execute"));
            }
        };
    }

    private static boolean isVirtualFileUnderSourceRoot(VirtualFile virtualFile, Project project) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return virtualFile != null && index.getContentRootForFile(virtualFile) != null;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        CfmlUnitRunnerParameters params = this.getRunnerParameters();
        String path = params.getPath();
        switch (params.getScope()) {
            case Method: 
            case Component: {
                if (StringUtil.isEmpty((String)path)) {
                    throw new RuntimeConfigurationError(CfmlBundle.message("cfml.runconfig.file.name.empty", path));
                }
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                if (file == null || !file.isValid() || file.isDirectory()) {
                    throw new RuntimeConfigurationError(CfmlBundle.message("cfml.runconfig.file.not.found", path));
                }
                if (!CfmlUnitRunConfiguration.isVirtualFileUnderSourceRoot(file, this.getProject())) {
                    throw new RuntimeConfigurationError(CfmlBundle.message("cfml.runconfig.file.not.in.project", path));
                }
                PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
                if (psiFile instanceof CfmlFile) break;
                throw new RuntimeConfigurationException("Incorrect file type");
            }
            case Directory: {
                if (StringUtil.isEmpty((String)path)) {
                    throw new RuntimeConfigurationError(CfmlBundle.message("cfml.runconfig.directory.name.empty", path));
                }
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                if (file == null || !file.isValid() || !file.isDirectory()) {
                    throw new RuntimeConfigurationError(CfmlBundle.message("cfml.runconfig.directory.not.found", path));
                }
                if (CfmlUnitRunConfiguration.isVirtualFileUnderSourceRoot(file, this.getProject())) break;
                throw new RuntimeConfigurationError(CfmlBundle.message("cfml.runconfig.directory.not.in.project", path));
            }
        }
        CfmlRunConfiguration.checkURL(params.getWebPath());
    }

    private ConsoleView createConsole(Project project, ProcessHandler processHandler, ExecutionEnvironment env, Executor executor) throws ExecutionException {
        CfmlUnitRunConfiguration runConfiguration = (CfmlUnitRunConfiguration)env.getRunProfile();
        CfmlUnitConsoleProperties consoleProps = new CfmlUnitConsoleProperties(runConfiguration, executor);
        consoleProps.addStackTraceFilter(new CfmlStackTraceFilterProvider(this.getProject()));
        BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"Cfml", (ProcessHandler)processHandler, (TestConsoleProperties)consoleProps);
        Disposer.register((Disposable)project, (Disposable)testsOutputConsoleView);
        return testsOutputConsoleView;
    }

    private void runTests(ProcessHandler processHandler) throws ExecutionException {
        CfmlUnitRemoteTestsRunner.executeScript(this.getRunnerParameters(), processHandler, this.getProject());
    }

    protected CfmlUnitRunnerParameters createRunnerParametersInstance() {
        return new CfmlUnitRunnerParameters();
    }

    public CfmlUnitRunnerParameters getRunnerParameters() {
        return this.myRunnerParameters;
    }

    public CfmlUnitRunConfiguration clone() {
        try {
            Element element = new Element("tmp");
            this.writeExternal(element);
            CfmlUnitRunConfiguration clone = new CfmlUnitRunConfiguration(this.getProject(), this.getFactory(), this.getName());
            clone.readExternal(element);
            return clone;
        }
        catch (WriteExternalException e) {
            throw new RuntimeException(e);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunnerParameters = this.createRunnerParametersInstance();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myRunnerParameters != null) {
            XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/mxunit/CfmlUnitRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/mxunit/CfmlUnitRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessHandler
    extends ProcessHandler {
        private MyProcessHandler() {
        }

        protected void destroyProcessImpl() {
            this.notifyProcessTerminated(0);
        }

        protected void detachProcessImpl() {
            this.notifyProcessDetached();
        }

        public boolean detachIsDefault() {
            return true;
        }

        public OutputStream getProcessInput() {
            return null;
        }
    }
}

