/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTokenRegistry {
    private static final THashMap<String, SqlTokenType> ourTokensMap = SqlTokenRegistry.newTokenMap();
    private static final THashMap<Class, Map<String, SqlKeywordTokenType>> ourClassTokensMap = ContainerUtil.newTroveMap();
    private static final THashMap<String, IElementType> ourCompositeMap = ContainerUtil.newTroveMap();
    private static Consumer<String> ourTestInterceptor;

    private SqlTokenRegistry() {
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(0);
        }
        SqlTokenType sqlTokenType = SqlTokenRegistry.getImpl(ourTokensMap, text, o -> Character.isLetter(o.charAt(0)) ? new SqlKeywordTokenType((String)o) : new SqlTokenType((String)o));
        if (sqlTokenType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(1);
        }
        return sqlTokenType;
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text, @NotNull Function<String, ? extends SqlTokenType> factory) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(3);
        }
        SqlTokenType sqlTokenType = SqlTokenRegistry.getImpl(ourTokensMap, text, factory);
        if (sqlTokenType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(4);
        }
        return sqlTokenType;
    }

    @NotNull
    public static SqlCompositeElementType getCompositeType(@NotNull String debugName) {
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(5);
        }
        SqlCompositeElementType sqlCompositeElementType = (SqlCompositeElementType)SqlTokenRegistry.getImpl(ourCompositeMap, debugName, o -> new SqlCompositeElementType((String)o));
        if (sqlCompositeElementType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(6);
        }
        return sqlCompositeElementType;
    }

    @NotNull
    public static <T extends IElementType> T getCompositeType(@NotNull String debugName, @NotNull Function<String, T> factory) {
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(7);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(8);
        }
        IElementType iElementType = SqlTokenRegistry.getImpl(ourCompositeMap, debugName, factory);
        if (iElementType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(9);
        }
        return (T)iElementType;
    }

    public static void setTestInterceptor(@NotNull Consumer<String> testInterceptor) {
        if (testInterceptor == null) {
            SqlTokenRegistry.$$$reportNull$$$0(10);
        }
        ourTestInterceptor = testInterceptor;
    }

    @NotNull
    private static synchronized <T extends IElementType> T getImpl(@NotNull Map<String, ? super T> map, @NotNull String debugName, @NotNull Function<String, T> factory) {
        IElementType type;
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(11);
        }
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(12);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(13);
        }
        if ((type = (IElementType)map.get(debugName)) == null) {
            type = (IElementType)ObjectUtils.notNull((Object)factory.fun((Object)debugName));
            map.put(debugName, type);
            if (ourTestInterceptor != null) {
                ourTestInterceptor.consume((Object)debugName);
            }
        }
        IElementType iElementType = type;
        if (iElementType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(14);
        }
        return (T)iElementType;
    }

    @Nullable
    public static synchronized SqlTokenType findTokenType(@NotNull String text) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(15);
        }
        return (SqlTokenType)((Object)ourTokensMap.get((Object)text));
    }

    @Nullable
    public static synchronized IElementType findCompositeType(@NotNull String text) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(16);
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @Nullable
    public static synchronized IElementType findType(@NotNull String text) {
        SqlTokenType token;
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(17);
        }
        if ((token = (SqlTokenType)((Object)ourTokensMap.get((Object)text))) != null) {
            return token;
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @NotNull
    public static synchronized Iterable<IElementType> getAllCompositeTypes() {
        Collection collection = ourCompositeMap.values();
        if (collection == null) {
            SqlTokenRegistry.$$$reportNull$$$0(18);
        }
        return collection;
    }

    public static void initTypeMap(@NotNull Class clazz, @Nullable Set<String> exclude) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(19);
        }
        Map<String, SqlKeywordTokenType> map = SqlTokenRegistry.buildTokenMap(clazz, SqlTokenRegistry.newTokenMap());
        if (exclude != null) {
            map.keySet().removeAll(exclude);
        }
        SqlTokenRegistry.setTypeMap(clazz, map, false);
    }

    public static synchronized void addTokensToClassMap(@NotNull Class clazz, @NotNull Set<String> keywordSet) {
        Map existing;
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(20);
        }
        if (keywordSet == null) {
            SqlTokenRegistry.$$$reportNull$$$0(21);
        }
        Object map = (existing = (Map)ourClassTokensMap.get((Object)clazz)) == null ? SqlTokenRegistry.newTokenMap() : existing;
        for (String s : keywordSet) {
            if (map.containsKey(s)) continue;
            String upperCase = StringUtil.toUpperCase((String)s);
            map.put(upperCase, (SqlKeywordTokenType)SqlTokenRegistry.getType(upperCase));
        }
        SqlTokenRegistry.setTypeMap(clazz, map, true);
    }

    private static synchronized void setTypeMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map, boolean force) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(22);
        }
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(23);
        }
        if (!force && ourClassTokensMap.containsKey((Object)clazz)) {
            return;
        }
        ourClassTokensMap.put((Object)clazz, map);
    }

    @NotNull
    public static NullableFunction<String, IElementType> getTokenProvider(@NotNull Class clazz) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(24);
        }
        NullableFunction nullableFunction = SqlTokenRegistry.getSafeMap(clazz)::get;
        if (nullableFunction == null) {
            SqlTokenRegistry.$$$reportNull$$$0(25);
        }
        return nullableFunction;
    }

    public static Set<String> getTokens(Class clazz) {
        return Collections.unmodifiableSet(SqlTokenRegistry.getSafeMap(clazz).keySet());
    }

    @NotNull
    private static synchronized Map<String, SqlKeywordTokenType> getSafeMap(@NotNull Class clazz) {
        Map result;
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(26);
        }
        if ((result = (Map)ourClassTokensMap.get((Object)clazz)) == null) {
            throw new AssertionError((Object)(clazz + " token map not initialized"));
        }
        Map map = result;
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(27);
        }
        return map;
    }

    private static <T extends IElementType> THashMap<String, T> newTokenMap() {
        return new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    private static Map<String, SqlKeywordTokenType> buildTokenMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(28);
        }
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(29);
        }
        SqlTokenRegistry.consumeStaticFieldsInOrder(clazz, (PairConsumer<Field, Object>)((PairConsumer)(field, value) -> {
            if (map == null) {
                SqlTokenRegistry.$$$reportNull$$$0(33);
            }
            if (value instanceof SqlKeywordTokenType) {
                SqlKeywordTokenType tokenType = (SqlKeywordTokenType)((Object)((Object)value));
                map.put(tokenType.toString(), tokenType);
            }
        }));
        return map;
    }

    public static void consumeStaticFieldsInOrder(@NotNull Class clazz, @NotNull PairConsumer<Field, Object> processor) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            SqlTokenRegistry.$$$reportNull$$$0(31);
        }
        JBIterable fields = ReflectionUtil.classTraverser((Class)clazz).postOrderDfsTraversal().flatMap(o -> JBIterable.of((Object[])o.getDeclaredFields())).filter(o -> Modifier.isStatic(o.getModifiers()));
        for (Field field : fields) {
            try {
                processor.consume((Object)field, field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static void ensureInterfacesAreInitializedInOrder(@NotNull Class<?> factoryClass) {
        if (factoryClass == null) {
            SqlTokenRegistry.$$$reportNull$$$0(32);
        }
        JBIterable interfaces = ReflectionUtil.classTraverser(factoryClass).postOrderDfsTraversal().filter(o -> o.isInterface());
        for (Class aClass : interfaces) {
            Field[] fields = aClass.getDeclaredFields();
            if (fields.length == 0) continue;
            try {
                fields[0].get(null);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/util/SqlTokenRegistry";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInterceptor";
                break;
            }
            case 11: 
            case 23: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordSet";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/util/SqlTokenRegistry";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompositeTypes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenProvider";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSafeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 25: 
            case 27: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTestInterceptor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findTokenType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCompositeType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initTypeMap";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTokensToClassMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setTypeMap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTokenProvider";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSafeMap";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildTokenMap";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "consumeStaticFieldsInOrder";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "ensureInterfacesAreInitializedInOrder";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildTokenMap$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

