/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public abstract class CreateClassActionBase
extends Intention {
    private final GrCreateClassKind myType;
    protected final GrReferenceElement myRefElement;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase");

    public CreateClassActionBase(GrCreateClassKind type, GrReferenceElement refElement) {
        this.myType = type;
        this.myRefElement = refElement;
    }

    @Override
    @NotNull
    public String getText() {
        String referenceName = this.myRefElement.getReferenceName();
        switch (this.getType()) {
            case TRAIT: {
                String string = GroovyBundle.message("create.trait", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(0);
                }
                return string;
            }
            case ENUM: {
                String string = GroovyBundle.message("create.enum", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(1);
                }
                return string;
            }
            case CLASS: {
                String string = GroovyBundle.message("create.class.text", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(2);
                }
                return string;
            }
            case INTERFACE: {
                String string = GroovyBundle.message("create.interface.text", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(3);
                }
                return string;
            }
            case ANNOTATION: {
                String string = GroovyBundle.message("create.annotation.text", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        if ("" == null) {
            CreateClassActionBase.$$$reportNull$$$0(5);
        }
        return "";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.class.family.name", new Object[0]);
        if (string == null) {
            CreateClassActionBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateClassActionBase.$$$reportNull$$$0(7);
        }
        return this.myRefElement.isValid() && ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRefElement) != null;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    protected GrCreateClassKind getType() {
        return this.myType;
    }

    @Nullable
    public static GrTypeDefinition createClassByType(@NotNull PsiDirectory directory, @NotNull String name, @NotNull PsiManager manager, @Nullable PsiElement contextElement, @NotNull String templateName, boolean allowReformatting) {
        if (directory == null) {
            CreateClassActionBase.$$$reportNull$$$0(8);
        }
        if (name == null) {
            CreateClassActionBase.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            CreateClassActionBase.$$$reportNull$$$0(10);
        }
        if (templateName == null) {
            CreateClassActionBase.$$$reportNull$$$0(11);
        }
        return (GrTypeDefinition)WriteAction.compute(() -> {
            if (directory == null) {
                CreateClassActionBase.$$$reportNull$$$0(17);
            }
            if (name == null) {
                CreateClassActionBase.$$$reportNull$$$0(18);
            }
            if (templateName == null) {
                CreateClassActionBase.$$$reportNull$$$0(19);
            }
            if (manager == null) {
                CreateClassActionBase.$$$reportNull$$$0(20);
            }
            try {
                GrTypeDefinition targetClass = null;
                try {
                    PsiFile file = GroovyTemplatesFactory.createFromTemplate(directory, name, name + ".groovy", templateName, allowReformatting, new String[0]);
                    for (PsiElement element : file.getChildren()) {
                        if (!(element instanceof GrTypeDefinition)) continue;
                        targetClass = (GrTypeDefinition)element;
                        break;
                    }
                    if (targetClass == null) {
                        throw new IncorrectOperationException(GroovyBundle.message("no.class.in.file.template", new Object[0]));
                    }
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (name == null) {
                            CreateClassActionBase.$$$reportNull$$$0(21);
                        }
                        Messages.showErrorDialog((String)GroovyBundle.message("cannot.create.class.error.text", name, e.getLocalizedMessage()), (String)GroovyBundle.message("cannot.create.class.error.title", new Object[0]));
                    });
                    return null;
                }
                GrModifierList modifiers = targetClass.getModifierList();
                if (contextElement != null && !JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper().isAccessible((PsiMember)targetClass, contextElement, null) && modifiers != null) {
                    modifiers.setModifierProperty("public", true);
                }
                return targetClass;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(@NotNull Project project, @NotNull String qualifier, @NotNull String name, @Nullable Module module, @NotNull String title) {
        if (project == null) {
            CreateClassActionBase.$$$reportNull$$$0(12);
        }
        if (qualifier == null) {
            CreateClassActionBase.$$$reportNull$$$0(13);
        }
        if (name == null) {
            CreateClassActionBase.$$$reportNull$$$0(14);
        }
        if (title == null) {
            CreateClassActionBase.$$$reportNull$$$0(15);
        }
        CreateClassDialog dialog = new CreateClassDialog(project, title, name, qualifier, this.getType(), false, module){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog.getTargetDirectory();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return CreateClassActionBase.this.myRefElement.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase$2", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            CreateClassActionBase.$$$reportNull$$$0(16);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: 
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createClassByType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDirectory";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createClassByType$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

