/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unassignedVariable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class UnassignedVariableAccessInspection
extends GroovyLocalInspectionBase {
    public boolean myIgnoreBooleanExpressions = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("ignore.boolean.expressions", new Object[0]), "myIgnoreBooleanExpressions");
        return optionsPanel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unassigned.access", new Object[0]);
        if (string == null) {
            UnassignedVariableAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected void check(@NotNull GrControlFlowOwner owner, @NotNull ProblemsHolder problemsHolder) {
        ReadWriteVariableInstruction[] reads;
        if (owner == null) {
            UnassignedVariableAccessInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            UnassignedVariableAccessInspection.$$$reportNull$$$0(2);
        }
        Instruction[] flow = owner.getControlFlow();
        for (ReadWriteVariableInstruction read : reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(flow, true)) {
            String name;
            GroovyPsiElement property;
            PsiElement element = read.getElement();
            if (!(element instanceof GroovyPsiElement) || element instanceof GrClosableBlock || (property = ResolveUtil.resolveProperty((GroovyPsiElement)element, name = read.getVariableName())) == null || property instanceof PsiParameter || property instanceof PsiField || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)property, (boolean)false) || this.myIgnoreBooleanExpressions && UnassignedVariableAccessInspection.isBooleanCheck(element)) continue;
            problemsHolder.registerProblem(element, GroovyInspectionBundle.message("unassigned.access.tooltip", name), new LocalQuickFix[0]);
        }
    }

    private static boolean isBooleanCheck(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof GrIfStatement && ((GrIfStatement)parent).getCondition() == element || parent instanceof GrWhileStatement && ((GrWhileStatement)parent).getCondition() == element || parent instanceof GrTraditionalForClause && ((GrTraditionalForClause)parent).getCondition() == element || UnassignedVariableAccessInspection.isLogicalExpression(parent) || parent instanceof GrUnaryExpression && ((GrUnaryExpression)parent).getOperationTokenType() == GroovyTokenTypes.mBNOT || UnassignedVariableAccessInspection.isCheckForNull(parent, element);
    }

    private static boolean isLogicalExpression(PsiElement parent) {
        return parent instanceof GrBinaryExpression && (((GrBinaryExpression)parent).getOperationTokenType() == GroovyTokenTypes.mLAND || ((GrBinaryExpression)parent).getOperationTokenType() == GroovyTokenTypes.mLOR);
    }

    private static boolean isCheckForNull(PsiElement parent, PsiElement element) {
        if (!(parent instanceof GrBinaryExpression)) {
            return false;
        }
        IElementType tokenType = ((GrBinaryExpression)parent).getOperationTokenType();
        if (tokenType != GroovyTokenTypes.mEQUAL && tokenType != GroovyTokenTypes.mNOT_EQUAL) {
            return false;
        }
        if (element == ((GrBinaryExpression)parent).getLeftOperand()) {
            GrExpression rightOperand = ((GrBinaryExpression)parent).getRightOperand();
            return rightOperand != null && GrInspectionUtil.isNull(rightOperand);
        }
        return GrInspectionUtil.isNull(((GrBinaryExpression)parent).getLeftOperand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/unassignedVariable/UnassignedVariableAccessInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/unassignedVariable/UnassignedVariableAccessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

