/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.hash.LinkedHashMap;
import icons.JetgroovyIcons;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.griffon.GriffonFramework;
import org.jetbrains.plugins.groovy.griffon.GriffonProjectViewState;
import org.jetbrains.plugins.groovy.griffon.GriffonSourceInspector;
import org.jetbrains.plugins.groovy.mvc.projectView.FileNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewState;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;
import org.jetbrains.plugins.groovy.mvc.projectView.TestsTopLevelDirectoryNode;
import org.jetbrains.plugins.groovy.mvc.projectView.TopLevelDirectoryNode;

public class GriffonToolWindowFactory
extends MvcToolWindowDescriptor {
    private static final Map<String, GriffonDirectoryMetadata> DIRECTORY_METADATA = new LinkedHashMap();

    public GriffonToolWindowFactory() {
        super(GriffonFramework.getInstance());
    }

    @Override
    public void fillModuleChildren(List<AbstractTreeNode> result, Module module, ViewSettings viewSettings, VirtualFile root) {
        PsiDirectory testsShared;
        PsiDirectory testsIntegration;
        PsiDirectory testsUnit;
        PsiDirectory srcCli;
        Project project = module.getProject();
        for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            VirtualFile[] metadata;
            PsiDirectory sourceRoot = PsiManager.getInstance((Project)project).findDirectory(file);
            if (sourceRoot == null || !"griffon-app".equals(file.getParent().getName()) || (metadata = DIRECTORY_METADATA.get(file.getName())) == null) continue;
            result.add((AbstractTreeNode)new TopLevelDirectoryNode(module, sourceRoot, viewSettings, metadata.description, metadata.icon, metadata.weight));
        }
        PsiDirectory srcMain = GriffonToolWindowFactory.findDirectory(project, root, "src/main");
        if (srcMain != null) {
            result.add((AbstractTreeNode)new TopLevelDirectoryNode(module, srcMain, viewSettings, "Project Sources", JetgroovyIcons.Groovy.Groovy_16x16, 70));
        }
        if ((srcCli = GriffonToolWindowFactory.findDirectory(project, root, "src/cli")) != null) {
            result.add((AbstractTreeNode)new TopLevelDirectoryNode(module, srcCli, viewSettings, "Build Sources", JetgroovyIcons.Groovy.Groovy_16x16, 70));
        }
        if ((testsUnit = GriffonToolWindowFactory.findDirectory(project, root, "test/unit")) != null) {
            result.add((AbstractTreeNode)new TestsTopLevelDirectoryNode(module, testsUnit, viewSettings, "Unit Tests", PlatformIcons.TEST_SOURCE_FOLDER, PlatformIcons.TEST_SOURCE_FOLDER));
        }
        if ((testsIntegration = GriffonToolWindowFactory.findDirectory(project, root, "test/integration")) != null) {
            result.add((AbstractTreeNode)new TestsTopLevelDirectoryNode(module, testsIntegration, viewSettings, "Integration Tests", PlatformIcons.TEST_SOURCE_FOLDER, PlatformIcons.TEST_SOURCE_FOLDER));
        }
        if ((testsShared = GriffonToolWindowFactory.findDirectory(project, root, "test/shared")) != null) {
            result.add((AbstractTreeNode)new TestsTopLevelDirectoryNode(module, testsShared, viewSettings, "Shared Test Sources", PlatformIcons.TEST_SOURCE_FOLDER, PlatformIcons.TEST_SOURCE_FOLDER));
        }
        for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            List<GriffonSourceInspector.GriffonSource> sources = GriffonSourceInspector.processModuleMetadata(module);
            for (GriffonSourceInspector.GriffonSource source : sources) {
                PsiDirectory dir = GriffonToolWindowFactory.findDirectory(project, file, source.getPath());
                if (dir == null) continue;
                result.add((AbstractTreeNode)new TopLevelDirectoryNode(module, dir, viewSettings, source.getNavigation().getDescription(), source.getNavigation().getIcon(), source.getNavigation().getWeight()));
            }
        }
        VirtualFile applicationPropertiesFile = GriffonFramework.getInstance().getApplicationPropertiesFile(module);
        GriffonToolWindowFactory.addFileNode(result, module, viewSettings, applicationPropertiesFile);
        for (VirtualFile file : root.getChildren()) {
            String name = file.getNameWithoutExtension();
            if (!name.endsWith("GriffonAddon") && !name.endsWith("GriffonPlugin")) continue;
            GriffonToolWindowFactory.addFileNode(result, module, viewSettings, file);
        }
    }

    private static void addFileNode(List<AbstractTreeNode> result, Module module, ViewSettings viewSettings, VirtualFile file) {
        PsiFile appProperties;
        if (file != null && (appProperties = PsiManager.getInstance((Project)module.getProject()).findFile(file)) != null) {
            result.add((AbstractTreeNode)new FileNode(module, appProperties, viewSettings));
        }
    }

    @Override
    public Icon getModuleNodeIcon() {
        return JetgroovyIcons.Griffon.Griffon;
    }

    @Override
    @NotNull
    public MvcProjectViewState getProjectViewState(Project project) {
        MvcProjectViewState mvcProjectViewState = (MvcProjectViewState)ServiceManager.getService((Project)project, GriffonProjectViewState.class);
        if (mvcProjectViewState == null) {
            GriffonToolWindowFactory.$$$reportNull$$$0(0);
        }
        return mvcProjectViewState;
    }

    static {
        DIRECTORY_METADATA.put("models", new GriffonDirectoryMetadata("Models", JetgroovyIcons.Mvc.ModelsNode, 20));
        DIRECTORY_METADATA.put("views", new GriffonDirectoryMetadata("Views", JetgroovyIcons.Groovy.Groovy_16x16, 30));
        DIRECTORY_METADATA.put("controllers", new GriffonDirectoryMetadata("Controllers", AllIcons.Nodes.KeymapTools, 40));
        DIRECTORY_METADATA.put("services", new GriffonDirectoryMetadata("Services", JetgroovyIcons.Mvc.Service, 50));
        DIRECTORY_METADATA.put("lifecycle", new GriffonDirectoryMetadata("Lifecycle", JetgroovyIcons.Groovy.Groovy_16x16, 60));
        DIRECTORY_METADATA.put("conf", new GriffonDirectoryMetadata("Configuration", JetgroovyIcons.Mvc.Config_folder_closed, 65));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonToolWindowFactory", "getProjectViewState"));
    }

    private static class GriffonDirectoryMetadata {
        public final String description;
        public final Icon icon;
        public final int weight;

        public GriffonDirectoryMetadata(String description, Icon icon, int weight) {
            this.description = description;
            this.icon = icon;
            this.weight = weight;
        }
    }
}

