/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteState;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class ControlFlowBuilderUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil");

    private ControlFlowBuilderUtil() {
    }

    public static ReadWriteVariableInstruction[] getReadsWithoutPriorWrites(Instruction[] flow, boolean onlyFirstRead) {
        DFAEngine<ReadBeforeWriteState> engine = new DFAEngine<ReadBeforeWriteState>(flow, new ReadBeforeWriteInstance(ControlFlowBuilderUtil.buildNamesIndex(flow), onlyFirstRead), ReadBeforeWriteSemilattice.INSTANCE);
        List<ReadBeforeWriteState> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return ReadWriteVariableInstruction.EMPTY_ARRAY;
        }
        ArrayList<ReadWriteVariableInstruction> result = new ArrayList<ReadWriteVariableInstruction>();
        BitSet reads = dfaResult.get(dfaResult.size() - 1).getReads();
        int i = reads.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            result.add((ReadWriteVariableInstruction)flow[i]);
            i = reads.nextSetBit(i + 1);
        }
        return result.toArray(ReadWriteVariableInstruction.EMPTY_ARRAY);
    }

    private static TObjectIntHashMap<String> buildNamesIndex(Instruction[] flow) {
        ObjectIntHashMap namesIndex = new ObjectIntHashMap();
        int idx = 0;
        for (Instruction instruction : flow) {
            String name;
            if (!(instruction instanceof ReadWriteVariableInstruction) || namesIndex.contains((Object)(name = ((ReadWriteVariableInstruction)instruction).getVariableName()))) continue;
            namesIndex.put((Object)name, idx++);
        }
        return namesIndex;
    }

    public static boolean isInstanceOfBinary(GrBinaryExpression binary) {
        if (binary.getOperationTokenType() == GroovyTokenTypes.kIN) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if (left instanceof GrReferenceExpression && ((GrReferenceExpression)left).getQualifier() == null && right instanceof GrReferenceExpression && ControlFlowBuilderUtil.findClassByText((GrReferenceExpression)right)) {
                return true;
            }
        }
        return false;
    }

    private static boolean findClassByText(GrReferenceExpression ref) {
        String text = ref.getText();
        int i = text.indexOf(60);
        String className = i == -1 ? text : text.substring(0, i);
        PsiClass[] names = PsiShortNamesCache.getInstance((Project)ref.getProject()).getClassesByName(className, ref.getResolveScope());
        if (names.length > 0) {
            return true;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof GroovyFile) {
            GrImportStatement[] imports2;
            for (GrImportStatement anImport : imports2 = ((GroovyFile)file).getImportStatements()) {
                if (!className.equals(anImport.getImportedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCertainlyReturnStatement(GrStatement st) {
        PsiElement parent = st.getParent();
        if (parent instanceof GrOpenBlock) {
            if (st != ArrayUtil.getLastElement((Object[])((GrOpenBlock)parent).getStatements())) {
                return false;
            }
            PsiElement pparent = parent.getParent();
            if (pparent instanceof GrMethod) {
                return true;
            }
            if (pparent instanceof GrBlockStatement || pparent instanceof GrCatchClause || pparent instanceof GrLabeledStatement) {
                pparent = pparent.getParent();
            }
            if (pparent instanceof GrIfStatement || pparent instanceof GrControlStatement || pparent instanceof GrTryCatchStatement) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)pparent);
            }
        } else {
            if (parent instanceof GrClosableBlock) {
                return st == ArrayUtil.getLastElement((Object[])((GrClosableBlock)parent).getStatements());
            }
            if (parent instanceof GroovyFileBase) {
                return st == ArrayUtil.getLastElement((Object[])((GroovyFileBase)parent).getStatements());
            }
            if (parent instanceof GrForStatement || parent instanceof GrIfStatement && st != ((GrIfStatement)parent).getCondition() || parent instanceof GrSynchronizedStatement && st != ((GrSynchronizedStatement)parent).getMonitor() || parent instanceof GrWhileStatement && st != ((GrWhileStatement)parent).getCondition() || parent instanceof GrConditionalExpression && st != ((GrConditionalExpression)parent).getCondition() || parent instanceof GrElvisExpression) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)parent);
            }
            if (parent instanceof GrCaseSection) {
                Object[] statements = ((GrCaseSection)parent).getStatements();
                GrStatement last = (GrStatement)ArrayUtil.getLastElement((Object[])statements);
                GrSwitchStatement switchStatement = (GrSwitchStatement)parent.getParent();
                if (last instanceof GrBreakStatement && statements.length > 1 && statements[statements.length - 2] == st) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchStatement);
                }
                if (st == last && (st instanceof GrBreakStatement || ControlFlowBuilderUtil.isLastStatementInCaseSection((GrCaseSection)parent, switchStatement))) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchStatement);
                }
            }
        }
        return false;
    }

    private static boolean isLastStatementInCaseSection(GrCaseSection caseSection, GrSwitchStatement switchStatement) {
        Object[] sections = switchStatement.getCaseSections();
        int i = ArrayUtilRt.find((Object[])sections, (Object)caseSection);
        if (i == sections.length - 1) {
            return true;
        }
        for (int j = i + 1; j < sections.length; ++j) {
            Object section = sections[j];
            for (GrStatement statement : section.getStatements()) {
                if (statement instanceof GrBreakStatement) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static GroovyResolveResult[] resolveNonQualifiedRefWithoutFlow(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            ControlFlowBuilderUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!ref.isQualified());
        String referenceName = ref.getReferenceName();
        PropertyResolverProcessor processor = new PropertyResolverProcessor(referenceName, ref);
        PsiTreeUtilKt.treeWalkUp(ref, processor);
        GroovyResolveResult[] candidates = ((ResolverProcessor)processor).getCandidates();
        if (candidates.length != 0) {
            if (candidates == null) {
                ControlFlowBuilderUtil.$$$reportNull$$$0(1);
            }
            return candidates;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            ControlFlowBuilderUtil.$$$reportNull$$$0(2);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNonQualifiedRefWithoutFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonQualifiedRefWithoutFlow";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

