/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrNumberConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        if (position == null) {
            GrNumberConverter.$$$reportNull$$$0(0);
        }
        return position != GrTypeConverter.ApplicableTo.METHOD_PARAMETER;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (targetType == null) {
            GrNumberConverter.$$$reportNull$$$0(1);
        }
        if (actualType == null) {
            GrNumberConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GrNumberConverter.$$$reportNull$$$0(3);
        }
        if (currentPosition == null) {
            GrNumberConverter.$$$reportNull$$$0(4);
        }
        if (PsiUtil.isCompileStatic(context)) {
            return GrNumberConverter.isCSConvertible(targetType, actualType);
        }
        if (TypesUtil.isNumericType(targetType) && TypesUtil.isNumericType(actualType)) {
            return ConversionResult.OK;
        }
        return null;
    }

    @Nullable
    private static ConversionResult isCSConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType) {
        if (targetType == null) {
            GrNumberConverter.$$$reportNull$$$0(5);
        }
        if (actualType == null) {
            GrNumberConverter.$$$reportNull$$$0(6);
        }
        if (TypesUtil.isClassType(actualType, "java.math.BigDecimal")) {
            return TypeConversionUtil.isFloatOrDoubleType((PsiType)targetType) ? ConversionResult.OK : null;
        }
        if (TypesUtil.isClassType(targetType, "java.math.BigDecimal")) {
            return TypesUtil.isNumericType(actualType) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        if (TypesUtil.isClassType(targetType, "java.math.BigInteger")) {
            return TypesUtil.isIntegralNumberType(actualType) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        if (TypesUtil.isClassType(actualType, "java.math.BigInteger")) {
            return TypesUtil.isClassType(targetType, "java.math.BigInteger") || TypesUtil.isClassType(targetType, "java.math.BigDecimal") ? ConversionResult.OK : null;
        }
        if (TypesUtil.isNumericType(targetType) && TypesUtil.isNumericType(actualType)) {
            return ConversionResult.OK;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrNumberConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertibleEx";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCSConvertible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

