/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.converters;

import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourcePathReferenceConverter<T>
extends JamSimpleReferenceConverter<List<T>> {
    public List<T> fromString(@Nullable String s, JamStringAttributeElement<List<T>> context) {
        return s == null ? null : this.getFiles(this.getReferences(s, context));
    }

    public List<T> getFiles(PsiReference[] references) {
        for (PsiReference reference : references) {
            FileReference lastFileReference;
            FileReference fileReference = FileReference.findFileReference((PsiReference)reference);
            if (fileReference == null || (lastFileReference = fileReference.getLastFileReference()) == null) continue;
            Object[] resolve = lastFileReference.multiResolve(false);
            return ContainerUtil.mapNotNull((Object[])resolve, this.getMapper());
        }
        return Collections.emptyList();
    }

    protected abstract Function<ResolveResult, T> getMapper();

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<List<T>> context) {
        PsiReference[] psiReferenceArray = this.getReferences(context);
        if (psiReferenceArray == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    protected PsiReference[] getReferences(@NotNull String s, JamStringAttributeElement<List<T>> context) {
        PsiLiteral psiLiteral;
        if (s == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(1);
        }
        if ((psiLiteral = context.getPsiLiteral()) == null) {
            return ResourcePathReferenceConverter.getReferencesOnFakeElement((PsiElement)context.getPsiElement(), s, new Module[0]);
        }
        return ResourcePathReferenceConverter.getReferences(psiLiteral, s, new Module[0]);
    }

    private static PsiReference[] getReferences(PsiLiteral psiLiteral, String s, Module ... modules) {
        SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create((PsiElement)psiLiteral, s).fromRoot(s.startsWith("/")).soft(false).modules(modules);
        return SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
    }

    @NotNull
    protected static PsiReference[] getReferencesOnFakeElement(@Nullable PsiElement element, @NotNull String s, Module ... modules) {
        block7: {
            PsiReference[] psiReferenceArray;
            if (s == null) {
                ResourcePathReferenceConverter.$$$reportNull$$$0(2);
            }
            if (element == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    ResourcePathReferenceConverter.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            try {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("\"" + s + "\"", element);
                if (!(psiExpression instanceof PsiLiteral)) break block7;
                psiReferenceArray = ResourcePathReferenceConverter.getReferences((PsiLiteral)psiExpression, s, modules);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (psiReferenceArray == null) {
                ResourcePathReferenceConverter.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private PsiReference[] getReferences(JamStringAttributeElement<List<T>> jamAttribute) {
        PsiLiteral psiLiteral = jamAttribute.getPsiLiteral();
        if (psiLiteral == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String s = ElementManipulators.getValueText((PsiElement)psiLiteral);
        return ResourcePathReferenceConverter.getReferences(psiLiteral, s, new Module[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesOnFakeElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesOnFakeElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

