/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.actions.GenerateJavaFromWsdlAction;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.engines.axis.AxisUtil;
import com.intellij.ws.engines.websphere.WebSphereWSEngine;
import com.intellij.ws.engines.wsengine.DialogWithWebServicePlatform;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.engines.wsengine.WSEngineManager;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.ui.GenerateJavaCodeDialogBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateJavaFromWsdlDialog
extends GenerateJavaCodeDialogBase
implements DialogWithWebServicePlatform {
    private static final ValidationInfo OK = new ValidationInfo("");
    JCheckBox generateTestCase;
    protected JComboBox packagePrefix;
    JCheckBox addLibs;
    private JPanel panel;
    ComboboxWithBrowseButton wsdlUrl;
    protected ComboBox outputPathes;
    JPasswordField password;
    JTextField user;
    private ComboBox webServicePlatform;
    private JLabel webServicePlatformText;
    private WSEngine currentEngine;
    private JLabel wsdlUrlText;
    private JLabel userText;
    private JLabel passwordText;
    protected JLabel outputPathesText;
    protected JLabel packagePrefixText;
    private static final String FAKE_WSDL_URL = AxisUtil.getWebServiceNS("", "simpleservice") + "?wsdl";
    JCheckBox generateClassesForSchemaArrays;
    ComboBox typeMappingVersion;
    private JLabel typeMappingText;
    JCheckBox wrappedDocumentSupport;
    JCheckBox generateUnreferencedElements;
    ComboBox outputMode;
    private JLabel outputModeText;
    static final String CLIENT_OUTPUT_MODE = "client";
    static final String SERVER_OUTPUT_MODE = "server";
    private ComboBox binding;
    private JLabel bindingText;
    private JCheckBox useExtensions;
    Runnable onSuccess;
    @NonNls
    private static final String WSDL_URL_IS_NOT_VALID = "Wsdl url is not valid";
    private final Module myForcedModule;
    private ValidationInfo myUrlValidationData;

    public GenerateJavaFromWsdlDialog(Project _project, @Nullable GenerateJavaFromWsdlDialog previousDialog, @Nullable Module module, @Nullable Runnable _onSuccess) {
        super(_project);
        this.onSuccess = _onSuccess;
        this.$$$setupUI$$$();
        if (this.onSuccess == null && previousDialog != null) {
            this.onSuccess = previousDialog.onSuccess;
        }
        this.myForcedModule = module;
        this.setTitle("Generate Java Code From Wsdl");
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        List<String> lastUrls = instance.getLastWsdlUrls();
        this.configureComboBox(this.wsdlUrl.getComboBox(), lastUrls);
        if (lastUrls.size() == 0) {
            this.wsdlUrl.getComboBox().addItem(FAKE_WSDL_URL);
            this.wsdlUrl.getComboBox().setSelectedIndex(0);
        }
        this.wsdlUrl.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateJavaFromWsdlDialog.this.myUrlValidationData = null;
            }
        });
        ComboBoxEditor editor = this.wsdlUrl.getComboBox().getEditor();
        ((JTextField)editor.getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GenerateJavaFromWsdlDialog.this.myUrlValidationData = null;
            }
        });
        this.configureBrowseButton(this.myProject, this.wsdlUrl, new String[]{"wsdl", "wadl"}, WSBundle.message("choose.wsdl.file.dialog.title", new Object[0]));
        this.doInitFor(this.userText, this.user, 'u');
        if (previousDialog != null) {
            this.user.setText(previousDialog.user.getText());
        }
        this.doInitFor(this.passwordText, this.password, 'p');
        if (previousDialog != null) {
            this.password.setText(previousDialog.password.getText());
        }
        this.doInitFor(this.outputModeText, (JComponent)this.outputMode, 'm');
        if (previousDialog != null) {
            this.outputMode.setSelectedItem(previousDialog.outputMode.getSelectedItem());
        }
        this.doInitFor(this.bindingText, (JComponent)this.binding, 'b');
        if (previousDialog != null) {
            this.binding.setSelectedItem(previousDialog.binding.getSelectedItem());
        }
        this.configureComboBox((JComboBox)this.outputMode, Arrays.asList(CLIENT_OUTPUT_MODE, SERVER_OUTPUT_MODE));
        if (previousDialog != null) {
            this.outputMode.setSelectedItem(previousDialog.outputMode.getSelectedItem());
        }
        this.configureComboBox((JComboBox)this.typeMappingVersion, Arrays.asList("1.1", "1.2"));
        this.doInitFor(this.typeMappingText, (JComponent)this.typeMappingVersion, 'v');
        if (previousDialog != null) {
            this.typeMappingVersion.setSelectedItem(previousDialog.typeMappingVersion.getSelectedItem());
        }
        this.generateClassesForSchemaArrays.setMnemonic('e');
        if (previousDialog != null) {
            this.generateClassesForSchemaArrays.setSelected(previousDialog.generateClassesForSchemaArrays.isSelected());
        }
        this.generateTestCase.setMnemonic('g');
        if (previousDialog != null) {
            this.generateTestCase.setSelected(previousDialog.generateTestCase.isSelected());
        }
        this.generateUnreferencedElements.setMnemonic('n');
        if (previousDialog != null) {
            this.generateUnreferencedElements.setSelected(previousDialog.generateUnreferencedElements.isSelected());
        }
        if (previousDialog != null) {
            this.wrappedDocumentSupport.setSelected(previousDialog.wrappedDocumentSupport.isSelected());
        }
        this.wrappedDocumentSupport.setMnemonic('d');
        this.doInitFor(this.wsdlUrlText, this.getUrl().getComboBox(), 'w');
        this.addLibs.setVisible(false);
        this.init();
        this.restoreCommonFieldsFromPreviousSession(previousDialog);
        WebServicePlatformUtils.initWSPlatforms(this);
        this.setupWSPlatformSpecificFields();
    }

    @Override
    public void setupWSPlatformSpecificFields() {
        String currentPlatform = (String)this.webServicePlatform.getSelectedItem();
        this.currentEngine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(currentPlatform);
        boolean isAxis = currentPlatform.equals("Apache Axis");
        boolean isWebSphere = currentPlatform.equals(WebSphereWSEngine.WEBSPHERE_PLATFORM);
        this.generateUnreferencedElements.setVisible(isAxis || isWebSphere);
        this.generateClassesForSchemaArrays.setVisible(isAxis || isWebSphere);
        this.wrappedDocumentSupport.setVisible(isAxis || isWebSphere);
        this.typeMappingText.setVisible(isAxis);
        this.typeMappingVersion.setVisible(isAxis);
        this.generateTestCase.setVisible(this.currentEngine.allowsTestCaseGeneration());
        this.outputModeText.setVisible(this.currentEngine.hasSeparateClientServerJavaCodeGenerationOption());
        this.outputMode.setVisible(this.currentEngine.hasSeparateClientServerJavaCodeGenerationOption());
        this.userText.setVisible(isAxis || isWebSphere);
        this.user.setVisible(isAxis || isWebSphere);
        this.password.setVisible(isAxis || isWebSphere);
        this.passwordText.setVisible(isAxis || isWebSphere);
        if (!this.user.isVisible()) {
            this.password.setText("");
            this.user.setText("");
        }
        boolean hasBindings = false;
        String[] supportedMappingTypes = this.currentEngine.getSupportedMappingTypesForJavaFromWsdl();
        if (supportedMappingTypes != null && supportedMappingTypes.length > 0) {
            this.configureComboBox((JComboBox)this.binding, Arrays.asList(supportedMappingTypes));
            String lastBinding = WebServicesPluginSettings.getInstance().getLastBinding();
            if (lastBinding != null) {
                this.binding.setSelectedItem((Object)lastBinding);
            }
            hasBindings = true;
        }
        this.binding.setVisible(hasBindings);
        this.bindingText.setVisible(hasBindings);
        this.pack();
    }

    @Override
    @Nullable
    public Module getSelectedModule() {
        Object item = this.outputPathes.getSelectedItem();
        return item == null ? null : LibUtils.findModuleByOutputPath(this.myProject, this.outputPathes.getSelectedItem().toString());
    }

    @Override
    public JComboBox getModuleChooser() {
        return null;
    }

    @Override
    public String[] getAvailableEngineNames() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        WSEngineManager engineManager = instance.getEngineManager();
        return engineManager.getAvailableWSEngineNames();
    }

    @Override
    protected boolean isAcceptableFile(VirtualFile virtualFile) {
        if (virtualFile != null) {
            return GenerateJavaFromWsdlAction.isAcceptableFileForGenerateJavaFromWsdl(virtualFile);
        }
        return false;
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("GenerateJavaFromWSDL.html" == null) {
            GenerateJavaFromWsdlDialog.$$$reportNull$$$0(0);
        }
        return "GenerateJavaFromWSDL.html";
    }

    public String getWebServicePlatform() {
        return (String)this.webServicePlatform.getSelectedItem();
    }

    @Override
    public JComboBox getWebServicePlatformCombo() {
        return this.webServicePlatform;
    }

    @Override
    public JLabel getWebServicePlaformText() {
        return this.webServicePlatformText;
    }

    public String getBindingType() {
        return (String)this.binding.getSelectedItem();
    }

    private void createUIComponents() {
        JavaCodeFragment fragment = this.setupFragment();
        this.packagePrefix = new EditorComboBox(PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment), this.myProject, (FileType)StdFileTypes.JAVA);
    }

    @Override
    protected ValidationInfo doValidUrlCheck(GenerateJavaCodeDialogBase.MyValidationData data) {
        return null;
    }

    @Override
    protected ValidationInfo doValidateWithData(GenerateJavaCodeDialogBase.MyValidationData _data) {
        ValidationData data = (ValidationData)_data;
        ValidationInfo validationResult = super.doValidateWithData(data);
        if (validationResult != null) {
            return validationResult;
        }
        try {
            String spec = ((String)data.currentUrl).trim();
            ValidationInfo info = this.getUrlInfo(spec, data);
            if (info != null && !info.equals((Object)OK)) {
                return info;
            }
            ValidationInfo result = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(this, this.currentEngine);
            if (result != null) {
                return result;
            }
            if (spec.endsWith("wadl")) {
                return new ValidationInfo("Web service engine does not support wadl files", (JComponent)this.wsdlUrl);
            }
        }
        catch (MalformedURLException ex) {
            LOG.debug((Throwable)ex);
            return new ValidationInfo(WSDL_URL_IS_NOT_VALID, (JComponent)this.wsdlUrl);
        }
        catch (IllegalArgumentException ex) {
            LOG.debug((Throwable)ex);
            return new ValidationInfo(WSDL_URL_IS_NOT_VALID, (JComponent)this.wsdlUrl);
        }
        catch (IOException ex) {
            LOG.debug((Throwable)ex);
            return new ValidationInfo("Wsdl url connection exception", (JComponent)this.wsdlUrl);
        }
        String item = ((EditorComboBox)this.packagePrefix).getText();
        if (this.packagePrefix.isVisible() && (item == null || item.trim().length() == 0)) {
            return new ValidationInfo("Package shouldn't be empty", (JComponent)this.packagePrefix);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationInfo getUrlInfo(String spec, ValidationData data) throws IOException {
        ValidationInfo urlValidationData = this.myUrlValidationData;
        if (urlValidationData != null) {
            return urlValidationData;
        }
        try {
            String contentType;
            String userName = data.currentUser.trim();
            URL url = new URL(spec);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Accepts", "text/xml");
            if (userName.length() > 0) {
                String userPassword = userName + ":" + data.currentPassword;
                String encoding = Base64.getEncoder().encodeToString(userPassword.getBytes(StandardCharsets.UTF_8));
                urlConnection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            try {
                contentType = urlConnection.getContentType();
            }
            catch (Exception e) {
                throw new MalformedURLException();
            }
            try (InputStream inputStream = null;){
                inputStream = urlConnection.getInputStream();
                new BufferedInputStream(inputStream).read();
            }
            if ("text/html".equals(contentType)) {
                this.myUrlValidationData = new ValidationInfo("Path to wsdl is not valid", (JComponent)this.wsdlUrl);
                return this.myUrlValidationData;
            }
            this.myUrlValidationData = OK;
            return null;
        }
        catch (IOException e) {
            this.myUrlValidationData = new ValidationInfo(WSDL_URL_IS_NOT_VALID, (JComponent)this.wsdlUrl);
            throw e;
        }
    }

    public Runnable getOnSuccess() {
        return this.onSuccess;
    }

    @Override
    protected ValidationData createValidationData() {
        return new ValidationData();
    }

    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Override
    protected JCheckBox getAddLibs() {
        return this.addLibs;
    }

    @Override
    protected EditorComboBox getPackagePrefix() {
        return (EditorComboBox)this.packagePrefix;
    }

    @Override
    protected Module getForcedModule() {
        return this.myForcedModule;
    }

    @Override
    protected JComboBox getOutputPaths() {
        return this.outputPathes;
    }

    @Override
    protected JLabel getOutputPathsText() {
        return this.outputPathesText;
    }

    @Override
    protected JLabel getPackagePrefixText() {
        return this.packagePrefixText;
    }

    @Override
    protected ComboboxWithBrowseButton getUrl() {
        return this.wsdlUrl;
    }

    @Override
    protected void doOKAction() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        instance.setLastPlatform(this.getWebServicePlatform());
        String bindingType = this.getBindingType();
        if (bindingType != null) {
            instance.setLastBinding(bindingType);
        }
        super.doOKAction();
    }

    public boolean useExtensions() {
        return this.useExtensions.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/GenerateJavaFromWsdlDialog", "getHelpId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JLabel jLabel;
        ComboBox comboBox2;
        JLabel jLabel2;
        ComboBox comboBox3;
        JLabel jLabel3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JLabel jLabel4;
        ComboBox comboBox4;
        JCheckBox jCheckBox4;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JLabel jLabel5;
        JLabel jLabel6;
        ComboBox comboBox5;
        JLabel jLabel7;
        JLabel jLabel8;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JLabel jLabel9;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 2, new Insets(1, 1, 1, 1), -1, -1, false, false));
        JComboBox jComboBox = this.packagePrefix;
        jComboBox.setEditable(true);
        jComboBox.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.packageprefix.tooltip"));
        jPanel.add((Component)jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.packagePrefixText = jLabel9 = new JLabel();
        jLabel9.setText("Package prefix");
        jLabel9.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.packageprefix.tooltip"));
        jPanel.add((Component)jLabel9, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generateTestCase = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox6.setText("Generate TestCase");
        jCheckBox6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.generateastestcase.tooltip"));
        jPanel.add((Component)jCheckBox6, new GridConstraints(10, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.addLibs = jCheckBox5 = new JCheckBox();
        jCheckBox5.setLabel("Add necessary libraries in order for generated code to compile and work");
        jCheckBox5.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox5.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.addrequiredlibs.tooltip"));
        jCheckBox5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.addrequiredlibs.tooltip"));
        jPanel.add((Component)jCheckBox5, new GridConstraints(14, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.wsdlUrlText = jLabel8 = new JLabel();
        jLabel8.setText("Web service wsdl url");
        jLabel8.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.url.tooltip"));
        jPanel.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPathesText = jLabel7 = new JLabel();
        jLabel7.setText("Output path");
        jLabel7.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.outputpath.tooltip"));
        jPanel.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPathes = comboBox5 = new ComboBox();
        comboBox5.setEditable(false);
        comboBox5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.outputpath.tooltip"));
        jPanel.add((Component)comboBox5, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.userText = jLabel6 = new JLabel();
        jLabel6.setText("User name");
        jLabel6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.user.tooltip"));
        jPanel.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.passwordText = jLabel5 = new JLabel();
        jLabel5.setText("Password");
        jLabel5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.password.tooltip"));
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.password = jPasswordField = new JPasswordField();
        jPasswordField.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.password.tooltip"));
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.user = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.user.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.wsdlUrl = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        comboboxWithBrowseButton.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.url.tooltip"));
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.generateClassesForSchemaArrays = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox4.setText("Generate classes for schema arrays");
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.generate.classes.for.schema.arrays.tooltip"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.typeMappingVersion = comboBox4 = new ComboBox();
        comboBox4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.typemapping.version.tooltip"));
        jPanel.add((Component)comboBox4, new GridConstraints(8, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.typeMappingText = jLabel4 = new JLabel();
        jLabel4.setText("Type mapping version");
        jLabel4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.typemapping.version.tooltip"));
        jPanel.add((Component)jLabel4, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generateUnreferencedElements = jCheckBox3 = new JCheckBox();
        jCheckBox3.setActionCommand("Generate unreferenced elements");
        jCheckBox3.setLabel("Generate unreferenced elements");
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox3.setText("Generate unreferenced elements");
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.generateunreferenced.elements.tooltip"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(12, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.wrappedDocumentSupport = jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand("Unwrap document/literal wrapped element");
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Support wrapped document/literal style");
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.wrapped.support.tooltip"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.outputModeText = jLabel3 = new JLabel();
        jLabel3.setText("Output mode");
        jLabel3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.output.mode.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputMode = comboBox3 = new ComboBox();
        comboBox3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.output.mode.tooltip"));
        jPanel.add((Component)comboBox3, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.webServicePlatformText = jLabel2 = new JLabel();
        jLabel2.setText("Web Service Platform");
        jLabel2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.platform.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.webServicePlatform = comboBox2 = new ComboBox();
        comboBox2.setEditable(false);
        comboBox2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.platform.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.bindingText = jLabel = new JLabel();
        jLabel.setText("Binding to be used");
        jLabel.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xfire.binding.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.binding = comboBox = new ComboBox();
        comboBox.setEditable(false);
        comboBox.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xfire.binding.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.useExtensions = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setSelected(true);
        jCheckBox.setText("Allow extensions");
        jCheckBox.setToolTipText("Allow vendor extensions");
        jPanel.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(15, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    class ValidationData
    extends GenerateJavaCodeDialogBase.MyValidationData {
        String currentUser;
        String currentPassword;
        String currentPlatform;

        ValidationData() {
            super(GenerateJavaFromWsdlDialog.this);
        }

        @Override
        protected void doAcquire() {
            super.doAcquire();
            this.currentUser = GenerateJavaFromWsdlDialog.this.user.getText();
            this.currentPassword = new String(GenerateJavaFromWsdlDialog.this.password.getPassword());
            this.currentPlatform = (String)GenerateJavaFromWsdlDialog.this.webServicePlatform.getSelectedItem();
        }
    }
}

