/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRangedReference
implements PsiReference {
    private final PsiElement myElement;
    private final TextRange myRange;

    public BaseRangedReference(PsiElement psiElement, int index, int endIndex) {
        this.myElement = psiElement;
        this.myRange = new TextRange(index, endIndex);
    }

    protected BaseRangedReference(PsiElement element, TextRange range) {
        this.myElement = element;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRange.substring(this.myElement.getText());
        if (string == null) {
            BaseRangedReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement handleElementRename(String string) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, string);
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            BaseRangedReference.$$$reportNull$$$0(1);
        }
        throw new IncorrectOperationException("old element: " + this.myElement + "; new element: " + psiElement + "; reference: " + this);
    }

    public boolean isReferenceTo(PsiElement psiElement) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/BaseRangedReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/BaseRangedReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

