/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ws.references.DelegatingClassReferenceThatReferencesAnyMethod;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CxfXmlReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String NS = "http://cxf.apache.org/jaxws";
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();
    @NonNls
    private static final String IMPLEMENTOR_ATTR_NAME = "implementor";
    @NonNls
    private static final String WSDL_LOCATION_ATTR_NAME = "wsdlLocation";
    private final MyReferenceProvider myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(true);

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new NamespaceFilter(new String[]{NS}), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{IMPLEMENTOR_ATTR_NAME, WSDL_LOCATION_ATTR_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            CxfXmlReferenceProvider.$$$reportNull$$$0(0);
        }
        if ((parent = element.getParent()) instanceof XmlAttribute) {
            if (IMPLEMENTOR_ATTR_NAME.equals(((XmlAttribute)parent).getName()) && element instanceof XmlAttributeValue) {
                XmlAttributeValue value = (XmlAttributeValue)element;
                if (value.getValue() != null && value.getValue().startsWith("#")) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        CxfXmlReferenceProvider.$$$reportNull$$$0(1);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] references = this.myClassProvider.getReferencesByElement(element);
                if (references.length > 0) {
                    PsiReference[] psiReferenceArray = CxfXmlReferenceProvider.updateLastClassRefWithAnyMemberRef(references);
                    if (psiReferenceArray == null) {
                        CxfXmlReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
            }
            PsiReference[] psiReferenceArray = this.myPathProvider.getReferencesByElement(element);
            if (psiReferenceArray == null) {
                CxfXmlReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            CxfXmlReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static PsiReference[] updateLastClassRefWithAnyMemberRef(PsiReference[] references) {
        PsiReference[] result = new PsiReference[references.length];
        System.arraycopy(references, 0, result, 0, references.length);
        references = result;
        references[references.length - 1] = new DelegatingClassReferenceThatReferencesAnyMethod(references[references.length - 1]);
        return references;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/CxfXmlReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/CxfXmlReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

