/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.LinkedValuesMapping;
import com.intellij.debugger.streams.ui.TraceController;
import com.intellij.debugger.streams.ui.ValueWithPosition;
import com.intellij.debugger.streams.ui.ValuesPositionsListener;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.debugger.streams.ui.impl.CollectionView;
import com.intellij.debugger.streams.ui.impl.FlatView;
import com.intellij.debugger.streams.ui.impl.FlatViewKt$sam$Function$a2f7e01b;
import com.intellij.debugger.streams.ui.impl.MappingPane;
import com.intellij.debugger.streams.ui.impl.PositionsAwareCollectionView;
import com.intellij.debugger.streams.ui.impl.SingleElementTree;
import com.intellij.debugger.streams.ui.impl.ValueWithPositionImpl;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.sun.jdi.Value;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/debugger/streams/ui/impl/FlatView;", "Ljavax/swing/JPanel;", "controllers", "", "Lcom/intellij/debugger/streams/ui/TraceController;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "(Ljava/util/List;Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;)V", "myPool", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "Lcom/intellij/debugger/streams/ui/impl/ValueWithPositionImpl;", "add", "Ljava/awt/Component;", "component", "getValue", "element", "resolve", "Lcom/intellij/debugger/streams/ui/impl/FlatView$LinkedValuesWithPositions;", "nextController", "LinkedValuesWithPositions", "stream-debugger"})
public class FlatView
extends JPanel {
    private final Map<TraceElement, ValueWithPositionImpl> myPool;

    @Override
    @NotNull
    public final Component add(@NotNull Component component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Component component2 = super.add(component);
        Intrinsics.checkExpressionValueIsNotNull((Object)component2, (String)"super.add(component)");
        return component2;
    }

    private final ValueWithPositionImpl getValue(TraceElement element) {
        Object object = getValue.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new FlatViewKt$sam$Function$a2f7e01b(function1);
        }
        ValueWithPositionImpl valueWithPositionImpl = this.myPool.computeIfAbsent(element, (Function)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)valueWithPositionImpl, (String)"myPool.computeIfAbsent(e\u2026 ::ValueWithPositionImpl)");
        return valueWithPositionImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedValuesWithPositions resolve(@NotNull TraceController $receiver, TraceController nextController) {
        Collection<ValueWithPositionImpl> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        LinkedValuesWithPositions linkedValuesWithPositions;
        Object key2;
        Object object;
        Object prevValue;
        List prevValues = new ArrayList();
        Map mapping = new LinkedHashMap();
        Iterator<TraceElement> iterator = $receiver.getTrace().iterator();
        while (iterator.hasNext()) {
            TraceElement element;
            TraceElement traceElement = element = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)traceElement, (String)"element");
            prevValue = this.getValue(traceElement);
            Collection collection2 = prevValues;
            collection2.add(prevValue);
            Iterator<TraceElement> iterator2 = $receiver.getNextValues(element).iterator();
            while (iterator2.hasNext()) {
                TraceElement nextElement;
                TraceElement traceElement2 = nextElement = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)traceElement2, (String)"nextElement");
                ValueWithPositionImpl nextValue = this.getValue(traceElement2);
                object = (Set)mapping.computeIfAbsent(prevValue, resolve.1.INSTANCE);
                object.add(nextValue);
                object = (Set)mapping.computeIfAbsent(nextValue, resolve.2.INSTANCE);
                object.add(prevValue);
            }
        }
        Map resultMapping = new LinkedHashMap();
        for (Object key2 : mapping.keySet()) {
            Object v = mapping.get(key2);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            resultMapping.put(key2, CollectionsKt.toList((Iterable)((Iterable)v)));
        }
        key2 = nextController.getTrace();
        List list2 = prevValues;
        LinkedValuesWithPositions linkedValuesWithPositions2 = linkedValuesWithPositions;
        LinkedValuesWithPositions linkedValuesWithPositions3 = linkedValuesWithPositions;
        prevValue = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (TraceElement item$iv$iv : $receiver$iv$iv) {
            void it;
            object = item$iv$iv;
            collection = destination$iv$iv;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            ValueWithPositionImpl valueWithPositionImpl = this.getValue((TraceElement)v4);
            collection.add(valueWithPositionImpl);
        }
        collection = (List)destination$iv$iv;
        linkedValuesWithPositions2(list2, (List<ValueWithPositionImpl>)collection, new LinkedValuesMapping(resultMapping){
            final /* synthetic */ Map $resultMapping;

            @Nullable
            public List<ValueWithPosition> getLinkedValues(@NotNull ValueWithPosition value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return (List)this.$resultMapping.get(value);
            }
            {
                this.$resultMapping = $captured_local_variable$0;
            }
        });
        return linkedValuesWithPositions3;
    }

    /*
     * WARNING - void declaration
     */
    public FlatView(@NotNull List<? extends TraceController> controllers, @NotNull EvaluationContextImpl evaluationContext) {
        Iterable valuesAfter;
        void prevMappingPane;
        Object tree;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(controllers, (String)"controllers");
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        super(new GridLayout(1, 2 * controllers.size() - 1));
        Object object5 = this;
        Object object6 = new LinkedHashMap();
        ((FlatView)object5).myPool = object6;
        Collection collection = controllers;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Iterable lastValues = null;
        for (Object object7 : CollectionsKt.withIndex((Iterable)controllers.subList(0, controllers.size() - 1))) {
            Collection<TraceElement> collection2;
            void $receiver$iv$iv;
            void $receiver$iv;
            CollectionTree collectionTree;
            void valuesBefore;
            StreamCall nextCall;
            int index = object7.component1();
            TraceController controller = (TraceController)object7.component2();
            object4 = this.resolve(controller, controllers.get(index + 1));
            List<ValueWithPositionImpl> list2 = ((LinkedValuesWithPositions)object4).component1();
            object3 = ((LinkedValuesWithPositions)object4).component2();
            LinkedValuesMapping mapping = ((LinkedValuesWithPositions)object4).component3();
            if (controller.getNextCall() == null) {
                object2 = "intermediate state should know about next call";
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            String string = nextCall.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nextCall.name");
            String string2 = TraceUtil.formatWithArguments(nextCall);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"TraceUtil.formatWithArguments(nextCall)");
            final MappingPane mappingPane = new MappingPane(string, string2, (List<? extends ValueWithPosition>)valuesBefore, mapping, controller);
            Iterable iterable = (Iterable)valuesBefore;
            List<Value> list3 = controller.getValues();
            object6 = collectionTree;
            object5 = collectionTree;
            void var16_23 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                object = (ValueWithPositionImpl)item$iv$iv;
                collection2 = destination$iv$iv;
                TraceElement traceElement = it.getTraceElement();
                collection2.add(traceElement);
            }
            collection2 = (List)destination$iv$iv;
            ((CollectionTree)object6)(list3, (List<TraceElement>)collection2, evaluationContext);
            tree = object5;
            final PositionsAwareCollectionView view = new PositionsAwareCollectionView((CollectionTree)tree, (List<ValueWithPositionImpl>)valuesBefore);
            controller.register(view);
            view.addValuesPositionsListener(new ValuesPositionsListener(){

                @Override
                public void valuesPositionsChanged() {
                    mappingPane.repaint();
                }
            });
            final MappingPane prevMapping = (MappingPane)prevMappingPane.element;
            if (prevMapping != null) {
                view.addValuesPositionsListener(new ValuesPositionsListener(){

                    @Override
                    public void valuesPositionsChanged() {
                        prevMapping.repaint();
                    }
                });
                prevMapping.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public final void mouseWheelMoved(MouseWheelEvent e) {
                        view.getInstancesTree().dispatchEvent(e);
                    }
                });
            }
            mappingPane.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public final void mouseWheelMoved(MouseWheelEvent e) {
                    view.getInstancesTree().dispatchEvent(e);
                }
            });
            this.add(view);
            this.add(mappingPane);
            prevMappingPane.element = mappingPane;
            lastValues = valuesAfter;
        }
        List list4 = lastValues;
        if (list4 != null) {
            Object object8;
            Object object9;
            void $receiver$iv;
            Object object10;
            Iterable<Value> values;
            Object object7;
            Object it = object7 = list4;
            TraceController lastController = (TraceController)CollectionsKt.last(controllers);
            StreamCall prevCall = lastController.getPrevCall();
            if (prevCall != null && prevCall instanceof TerminatorStreamCall) {
                void $receiver$iv$iv;
                SingleElementTree singleElementTree;
                values = lastController.getValues();
                valuesAfter = (Iterable)it;
                object10 = (Value)CollectionsKt.first(values);
                object4 = singleElementTree;
                object2 = singleElementTree;
                tree = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (ValueWithPositionImpl item$iv$iv2 : $receiver$iv$iv) {
                    void it2;
                    ValueWithPositionImpl valueWithPositionImpl = item$iv$iv2;
                    object9 = destination$iv$iv;
                    object = it2.getTraceElement();
                    object9.add(object);
                }
                object9 = (List)destination$iv$iv;
                ((SingleElementTree)object4)((Value)object10, (List<TraceElement>)object9, evaluationContext);
                object8 = (CollectionTree)object2;
            } else {
                void $receiver$iv$iv;
                void $receiver$iv2;
                CollectionTree collectionTree;
                values = (Iterable)it;
                object10 = lastController.getValues();
                object4 = collectionTree;
                object2 = collectionTree;
                $receiver$iv = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it3;
                    ValueWithPositionImpl item$iv$iv2;
                    item$iv$iv2 = (ValueWithPositionImpl)item$iv$iv;
                    object9 = destination$iv$iv;
                    object = it3.getTraceElement();
                    object9.add(object);
                }
                object9 = (List)destination$iv$iv;
                object8 = object2;
                ((CollectionTree)object4)((List<Value>)object10, (List<TraceElement>)object9, evaluationContext);
            }
            Object tree2 = object8;
            PositionsAwareCollectionView view = new PositionsAwareCollectionView((CollectionTree)tree2, (List<ValueWithPositionImpl>)it);
            lastController.register(view);
            view.addValuesPositionsListener(new ValuesPositionsListener(this, controllers, evaluationContext, (Ref.ObjectRef)prevMappingPane){
                final /* synthetic */ FlatView this$0;
                final /* synthetic */ List $controllers$inlined;
                final /* synthetic */ EvaluationContextImpl $evaluationContext$inlined;
                final /* synthetic */ Ref.ObjectRef $prevMappingPane$inlined;
                {
                    this.this$0 = flatView;
                    this.$controllers$inlined = list2;
                    this.$evaluationContext$inlined = evaluationContextImpl;
                    this.$prevMappingPane$inlined = objectRef;
                }

                public void valuesPositionsChanged() {
                    block0: {
                        MappingPane mappingPane = (MappingPane)this.$prevMappingPane$inlined.element;
                        if (mappingPane == null) break block0;
                        mappingPane.repaint();
                    }
                }
            });
            MappingPane mappingPane = (MappingPane)prevMappingPane.element;
            if (mappingPane != null) {
                Object it4 = object3 = mappingPane;
                ((Component)it4).addMouseWheelListener(new MouseWheelListener(view){
                    final /* synthetic */ PositionsAwareCollectionView $view$inlined;
                    {
                        this.$view$inlined = positionsAwareCollectionView;
                    }

                    public final void mouseWheelMoved(MouseWheelEvent e) {
                        this.$view$inlined.getInstancesTree().dispatchEvent(e);
                    }
                });
            }
            this.add(view);
        }
        if (controllers.size() == 1) {
            TraceController controller = controllers.get(0);
            CollectionTree tree3 = new CollectionTree(controller.getValues(), controller.getTrace(), evaluationContext);
            CollectionView view = new CollectionView(tree3);
            this.add(view);
            controller.register(view);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/streams/ui/impl/FlatView$LinkedValuesWithPositions;", "", "valuesBefore", "", "Lcom/intellij/debugger/streams/ui/impl/ValueWithPositionImpl;", "valuesAfter", "mapping", "Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;)V", "getMapping", "()Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;", "getValuesAfter", "()Ljava/util/List;", "getValuesBefore", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "stream-debugger"})
    private static final class LinkedValuesWithPositions {
        @NotNull
        private final List<ValueWithPositionImpl> valuesBefore;
        @NotNull
        private final List<ValueWithPositionImpl> valuesAfter;
        @NotNull
        private final LinkedValuesMapping mapping;

        @NotNull
        public final List<ValueWithPositionImpl> getValuesBefore() {
            return this.valuesBefore;
        }

        @NotNull
        public final List<ValueWithPositionImpl> getValuesAfter() {
            return this.valuesAfter;
        }

        @NotNull
        public final LinkedValuesMapping getMapping() {
            return this.mapping;
        }

        public LinkedValuesWithPositions(@NotNull List<ValueWithPositionImpl> valuesBefore, @NotNull List<ValueWithPositionImpl> valuesAfter, @NotNull LinkedValuesMapping mapping) {
            Intrinsics.checkParameterIsNotNull(valuesBefore, (String)"valuesBefore");
            Intrinsics.checkParameterIsNotNull(valuesAfter, (String)"valuesAfter");
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            this.valuesBefore = valuesBefore;
            this.valuesAfter = valuesAfter;
            this.mapping = mapping;
        }

        @NotNull
        public final List<ValueWithPositionImpl> component1() {
            return this.valuesBefore;
        }

        @NotNull
        public final List<ValueWithPositionImpl> component2() {
            return this.valuesAfter;
        }

        @NotNull
        public final LinkedValuesMapping component3() {
            return this.mapping;
        }

        @NotNull
        public final LinkedValuesWithPositions copy(@NotNull List<ValueWithPositionImpl> valuesBefore, @NotNull List<ValueWithPositionImpl> valuesAfter, @NotNull LinkedValuesMapping mapping) {
            Intrinsics.checkParameterIsNotNull(valuesBefore, (String)"valuesBefore");
            Intrinsics.checkParameterIsNotNull(valuesAfter, (String)"valuesAfter");
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            return new LinkedValuesWithPositions(valuesBefore, valuesAfter, mapping);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LinkedValuesWithPositions copy$default(LinkedValuesWithPositions linkedValuesWithPositions, List list2, List list3, LinkedValuesMapping linkedValuesMapping, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = linkedValuesWithPositions.valuesBefore;
            }
            if ((n & 2) != 0) {
                list3 = linkedValuesWithPositions.valuesAfter;
            }
            if ((n & 4) != 0) {
                linkedValuesMapping = linkedValuesWithPositions.mapping;
            }
            return linkedValuesWithPositions.copy(list2, list3, linkedValuesMapping);
        }

        public String toString() {
            return "LinkedValuesWithPositions(valuesBefore=" + this.valuesBefore + ", valuesAfter=" + this.valuesAfter + ", mapping=" + this.mapping + ")";
        }

        public int hashCode() {
            List<ValueWithPositionImpl> list2 = this.valuesBefore;
            List<ValueWithPositionImpl> list3 = this.valuesAfter;
            LinkedValuesMapping linkedValuesMapping = this.mapping;
            return ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (linkedValuesMapping != null ? linkedValuesMapping.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LinkedValuesWithPositions)) break block3;
                    LinkedValuesWithPositions linkedValuesWithPositions = (LinkedValuesWithPositions)object;
                    if (!Intrinsics.areEqual(this.valuesBefore, linkedValuesWithPositions.valuesBefore) || !Intrinsics.areEqual(this.valuesAfter, linkedValuesWithPositions.valuesAfter) || !Intrinsics.areEqual((Object)this.mapping, (Object)linkedValuesWithPositions.mapping)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

