/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.angularjs.cli.AngularJSProjectConfigurator;
import org.angularjs.cli.Blueprint;
import org.angularjs.cli.BlueprintParser;
import org.angularjs.cli.BlueprintsExternalizer;
import org.angularjs.cli.BlueprintsLoaderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"(\u0010\u0002\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005 \u0006*\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DEFAULT_OUTPUT", "", "ourGist", "Lcom/intellij/util/gist/VirtualFileGist;", "", "Lorg/angularjs/cli/Blueprint;", "kotlin.jvm.PlatformType", "doLoad", "project", "Lcom/intellij/openapi/project/Project;", "cli", "Lcom/intellij/openapi/vfs/VirtualFile;", "findAngularCliFolder", "file", "AngularJS"})
public final class BlueprintsLoaderKt {
    private static VirtualFileGist<List<Blueprint>> ourGist = GistManager.getInstance().newVirtualFileGist("AngularBlueprints", 1, (DataExternalizer)new BlueprintsExternalizer(), (VirtualFileGist.GistCalculator)ourGist.1.INSTANCE);
    @NotNull
    public static final String DEFAULT_OUTPUT = "\n\n  Available blueprints:\n    class <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    component <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --inline-template (Boolean) Specifies if the template will be in the ts file.\n        aliases: -it, --inlineTemplate\n      --inline-style (Boolean) Specifies if the style will be in the ts file.\n        aliases: -is, --inlineStyle\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --view-encapsulation (String) Specifies the view encapsulation strategy.\n        aliases: -ve <value>, --viewEncapsulation <value>\n      --change-detection (String) Specifies the change detection strategy.\n        aliases: -cd <value>, --changeDetection <value>\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    directive <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    enum <name> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    guard <name> <options...>\n      --flat (Boolean) Indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n    interface <interface-type> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    module <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --routing (Boolean) (Default: false) Specifies if a routing module file should be generated.\n        aliases: --routing\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    pipe <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the pipe.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    service <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n\nng generate <blueprint> <options...>\n  Generates new code from blueprints.\n  aliases: g\n  --dry-run (Boolean) (Default: false) Run through without making any changes.\n    aliases: -d, --dryRun\n  --verbose (Boolean) (Default: false) Adds more details to output logging.\n    aliases: -v, --verbose\n\n    ";

    private static final List<Blueprint> doLoad(Project project, VirtualFile cli) {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (nodeJsLocalInterpreter == null) {
            return CollectionsKt.emptyList();
        }
        NodeJsLocalInterpreter node = nodeJsLocalInterpreter;
        List modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"@angular/cli", (VirtualFile)cli, (boolean)false, (NodeJsInterpreter)((NodeJsInterpreter)node));
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules);
        if (completionModuleInfo == null) {
            return CollectionsKt.emptyList();
        }
        CompletionModuleInfo module = completionModuleInfo;
        StringBuilder stringBuilder = new StringBuilder().append("");
        VirtualFile virtualFile = module.getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        String moduleExe = stringBuilder.append(virtualFile.getPath()).append("").append(File.separator).append("bin").append(File.separator).append("ng").toString();
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{node.getInterpreterSystemDependentPath(), moduleExe, "help", "generate"});
        commandLine.withWorkDirectory(cli.getPath());
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = handler.runProcess();
        BlueprintParser parser = new BlueprintParser();
        Collection<Blueprint> parse = CollectionsKt.emptyList();
        if (output.getExitCode() == 0) {
            String string = output.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stdout");
            parse = parser.parse(string);
        }
        if (parse.isEmpty()) {
            parse = parser.parse(DEFAULT_OUTPUT);
        }
        Iterable $receiver$iv = parse;
        return CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                Blueprint it = (Blueprint)a;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Blueprint)b;
                Comparable comparable2 = comparable;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
    }

    @Nullable
    public static final VirtualFile findAngularCliFolder(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || AngularJSProjectConfigurator.findCliJson(current) == null) continue;
            return current;
        }
        if (AngularJSProjectConfigurator.findCliJson(project.getBaseDir()) != null) {
            return project.getBaseDir();
        }
        return null;
    }

    @NotNull
    public static final /* synthetic */ VirtualFileGist access$getOurGist$p() {
        return ourGist;
    }

    public static final /* synthetic */ void access$setOurGist$p(@NotNull VirtualFileGist virtualFileGist) {
        ourGist = virtualFileGist;
    }

    @NotNull
    public static final /* synthetic */ List access$doLoad(@NotNull Project project, @NotNull VirtualFile cli) {
        return BlueprintsLoaderKt.doLoad(project, cli);
    }
}

