/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.environment;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentIndex;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestEnvironment {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.environment.HttpRequestEnvironment");
    private static final String DEFAULT_EXECUTION_ENVIRONMENT = "rest.client.default.execution.environment";

    @Nullable
    public abstract String getVariableValue(@NotNull String var1);

    public static void setDefaultEnvName(@NotNull Project project, @NotNull String env) {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(0);
        }
        if (env == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(1);
        }
        PropertiesComponent.getInstance((Project)project).setValue(DEFAULT_EXECUTION_ENVIRONMENT, env);
    }

    @Nullable
    public static String getDefaultEnvName(@NotNull Project project) {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(2);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT);
    }

    @Nullable
    public static HttpRequestEnvironment getDefault(@NotNull Project project) throws HttpRequestValidationException {
        String env;
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(3);
        }
        return StringUtil.isNotEmpty((String)(env = PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT))) ? HttpRequestEnvironment.create(project, env) : null;
    }

    @NotNull
    public static HttpRequestEnvironment empty() {
        HttpRequestEmptyEnvironment httpRequestEmptyEnvironment = HttpRequestEmptyEnvironment.EMPTY_ENVIRONMENT;
        if (httpRequestEmptyEnvironment == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(4);
        }
        return httpRequestEmptyEnvironment;
    }

    @NotNull
    public static HttpRequestEnvironment create(@NotNull Project project, @Nullable String env) throws HttpRequestValidationException {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)env)) {
            Collection files = FileBasedIndex.getInstance().getContainingFiles(HttpRequestEnvironmentIndex.KEY, (Object)env, GlobalSearchScope.projectScope((Project)project));
            if (files.isEmpty()) {
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.find.environment", env));
            }
            if (files.size() > 1) {
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.multiple.environments", env));
            }
            PsiFile file = PsiManager.getInstance((Project)project).findFile((VirtualFile)files.iterator().next());
            if (file instanceof JsonFile) {
                JsonObject environment;
                JsonValue value = ((JsonFile)file).getTopLevelValue();
                JsonObject jsonObject = environment = value instanceof JsonObject ? (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)((JsonObject)value), (String)env, JsonObject.class) : null;
                if (environment != null) {
                    HttpRequestJsonEnvironment httpRequestJsonEnvironment = new HttpRequestJsonEnvironment(environment);
                    if (httpRequestJsonEnvironment == null) {
                        HttpRequestEnvironment.$$$reportNull$$$0(6);
                    }
                    return httpRequestJsonEnvironment;
                }
            }
        }
        HttpRequestEmptyEnvironment httpRequestEmptyEnvironment = HttpRequestEmptyEnvironment.EMPTY_ENVIRONMENT;
        if (httpRequestEmptyEnvironment == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(7);
        }
        return httpRequestEmptyEnvironment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/environment/HttpRequestEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultEnvName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEnvName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpRequestEmptyEnvironment
    extends HttpRequestEnvironment {
        private static final HttpRequestEmptyEnvironment EMPTY_ENVIRONMENT = new HttpRequestEmptyEnvironment();

        private HttpRequestEmptyEnvironment() {
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            if (name == null) {
                HttpRequestEmptyEnvironment.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/http/request/environment/HttpRequestEnvironment$HttpRequestEmptyEnvironment", "getVariableValue"));
        }
    }

    private static class HttpRequestJsonEnvironment
    extends HttpRequestEnvironment {
        @NotNull
        private JsonObject myVariables;

        public HttpRequestJsonEnvironment(@NotNull JsonObject variables) {
            if (variables == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(0);
            }
            this.myVariables = variables;
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            if (name == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            JsonLiteral value = (JsonLiteral)JsonUtil.getPropertyValueOfType((JsonObject)this.myVariables, (String)name, JsonLiteral.class);
            if (value instanceof JsonStringLiteral) {
                return ((JsonStringLiteral)value).getValue();
            }
            if (value instanceof JsonBooleanLiteral) {
                return String.valueOf(((JsonBooleanLiteral)value).getValue());
            }
            return value != null ? value.getText() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestEnvironment$HttpRequestJsonEnvironment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVariableValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

