/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.ws.http.request.run.HttpResponsePresentation;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpResponseConsolePrinter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpClientResponseHandler");
    private Project myProject;
    private ConsoleViewImpl myConsole;
    private Ref<FileType> mySelectedFileType;
    private String myTargetRequestLine;
    private HttpResponsePresentation myResponse;

    public HttpResponseConsolePrinter(@NotNull Project project, @NotNull String target) {
        if (project == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(0);
        }
        if (target == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(1);
        }
        this.mySelectedFileType = new Ref((Object)PlainTextFileType.INSTANCE);
        this.myResponse = null;
        this.myProject = project;
        this.myConsole = new HttpResponseConsoleView(project);
        this.myTargetRequestLine = target;
        this.myConsole.print(this.myTargetRequestLine, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void setResponse(@NotNull HttpResponsePresentation response, @NotNull FileType fileType) {
        if (response == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(3);
        }
        this.myResponse = response;
        this.mySelectedFileType = new Ref((Object)fileType);
        this.myResponse.print(this.myProject, (ConsoleView)this.myConsole, fileType, this.mySelectedFileType);
    }

    public void attachToProcess(@NotNull ProcessHandler handler) {
        if (handler == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(4);
        }
        this.myConsole.attachToProcess(handler);
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleViewImpl consoleViewImpl = this.myConsole;
        if (consoleViewImpl == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(5);
        }
        return consoleViewImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setResponse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HttpResponseConsoleView
    extends ConsoleViewImpl {
        public HttpResponseConsoleView(Project project) {
            if (project == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(0);
            }
            super(project, false);
        }

        @NotNull
        public AnAction[] createConsoleActions() {
            AnAction[] oldActions = super.createConsoleActions();
            ArrayList<Object> newActions = new ArrayList<Object>(oldActions.length);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, "View as text", "Show response body as a raw file", (FileType)PlainTextFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, (FileType)JsonFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, (FileType)XmlFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, (FileType)HtmlFileType.INSTANCE));
            group.addSeparator();
            newActions.add(group);
            for (AnAction action : oldActions) {
                if (action instanceof PreviousOccurenceToolbarAction || action instanceof NextOccurenceToolbarAction) continue;
                newActions.add(action);
            }
            AnAction[] anActionArray = newActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter$HttpResponseConsoleView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter$HttpResponseConsoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConsoleActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class HttpResponseReformatBaseAction
    extends ToggleAction {
        public HttpResponseReformatBaseAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        @Nullable
        public abstract FileType getFileType();

        public boolean isSelected(AnActionEvent e) {
            return HttpResponseConsolePrinter.this.mySelectedFileType.get() == this.getFileType();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FileType type;
            if (state && HttpResponseConsolePrinter.this.myResponse != null && (type = this.getFileType()) != null && HttpResponseConsolePrinter.this.mySelectedFileType.get() != type) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reformat response body as " + type.getName());
                }
                HttpResponseConsolePrinter.this.mySelectedFileType.set((Object)type);
                HttpResponseConsolePrinter.this.myConsole.clear();
                HttpResponseConsolePrinter.this.myConsole.print(HttpResponseConsolePrinter.this.myTargetRequestLine, ConsoleViewContentType.SYSTEM_OUTPUT);
                HttpResponseConsolePrinter.this.myResponse.print(HttpResponseConsolePrinter.this.myProject, (ConsoleView)HttpResponseConsolePrinter.this.myConsole, type, (Ref<FileType>)HttpResponseConsolePrinter.this.mySelectedFileType);
            }
        }
    }

    private class HttpResponseReformatAction
    extends HttpResponseReformatBaseAction {
        private FileType myFileType;
        final /* synthetic */ HttpResponseConsolePrinter this$0;

        public HttpResponseReformatAction(@NotNull HttpResponseConsolePrinter httpResponseConsolePrinter, FileType fileType) {
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(0);
            }
            this(httpResponseConsolePrinter, "View as " + fileType.getName(), "Reformat and highlight file as " + fileType.getName(), fileType);
        }

        public HttpResponseReformatAction(@NotNull HttpResponseConsolePrinter httpResponseConsolePrinter, @NotNull String text, @NotNull String description, FileType fileType) {
            if (text == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(1);
            }
            if (description == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(3);
            }
            this.this$0 = httpResponseConsolePrinter;
            super(text, description, fileType.getIcon());
            this.myFileType = fileType;
        }

        @Override
        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter$HttpResponseReformatAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

