/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.async;

import java.util.Collection;
import java.util.LinkedList;
import org.lobobrowser.async.AsyncResult;
import org.lobobrowser.async.AsyncResultEvent;
import org.lobobrowser.async.AsyncResultListener;

public class AsyncResultWrapper<TResult>
implements AsyncResult<TResult>,
AsyncResultListener<TResult> {
    private AsyncResult<TResult> ar;
    private final Collection<AsyncResultListener<TResult>> listeners = new LinkedList<AsyncResultListener<TResult>>();

    public AsyncResultWrapper(AsyncResult<TResult> ar) {
        this.ar = ar;
    }

    public void setAsyncResult(AsyncResult<TResult> ar) {
        AsyncResult<TResult> oldResult = this.ar;
        if (oldResult != null) {
            oldResult.removeResultListener(this);
        }
        if (ar != null) {
            ar.addResultListener(this);
        }
        this.ar = ar;
    }

    public AsyncResult<TResult> getAsyncResult() {
        return this.ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResultListener(AsyncResultListener<TResult> listener) {
        AsyncResultWrapper asyncResultWrapper = this;
        synchronized (asyncResultWrapper) {
            this.listeners.add(listener);
        }
        AsyncResult<TResult> ar = this.ar;
        if (ar != null) {
            ar.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResultListener(AsyncResultListener<TResult> listener) {
        AsyncResultWrapper asyncResultWrapper = this;
        synchronized (asyncResultWrapper) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionReceived(AsyncResultEvent<Throwable> event) {
        AsyncResultListener[] listenersArray;
        AsyncResultWrapper asyncResultWrapper = this;
        synchronized (asyncResultWrapper) {
            listenersArray = this.listeners.toArray(new AsyncResultListener[0]);
        }
        for (int i = 0; i < listenersArray.length; ++i) {
            AsyncResultListener arl = listenersArray[i];
            arl.exceptionReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resultReceived(AsyncResultEvent<TResult> event) {
        AsyncResultListener[] listenersArray;
        AsyncResultWrapper asyncResultWrapper = this;
        synchronized (asyncResultWrapper) {
            listenersArray = this.listeners.toArray(new AsyncResultListener[0]);
        }
        for (int i = 0; i < listenersArray.length; ++i) {
            AsyncResultListener arl = listenersArray[i];
            arl.resultReceived(event);
        }
    }

    @Override
    public void signal() {
        AsyncResult<TResult> ar = this.ar;
        if (ar != null) {
            ar.signal();
        }
    }
}

