/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.context;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lobobrowser.clientlet.ClientletAccess;
import org.lobobrowser.clientlet.ClientletContext;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.http.Method;
import org.lobobrowser.http.Request;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.request.SimpleRequestHandler;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.NetworkRequest;
import org.lobobrowser.ua.NetworkRequestEvent;
import org.lobobrowser.ua.NetworkRequestListener;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Urls;
import org.w3c.dom.Document;

public class NetworkRequestImpl
implements NetworkRequest {
    private static final Logger logger = Logger.getLogger(NetworkRequestImpl.class.getName());
    private final EventDispatch READY_STATE_CHANGE = new EventDispatch();
    private volatile int readyState = 0;
    private volatile LocalResponse localResponse;
    private Request req = new Request();
    private boolean isAsynchronous = false;
    private volatile RequestHandler currentRequestHandler;

    @Override
    public int getReadyState() {
        return this.readyState;
    }

    @Override
    public String getResponseText() {
        LocalResponse lr = this.localResponse;
        return lr == null ? null : lr.getResponseText();
    }

    @Override
    public Document getResponseXML() {
        LocalResponse lr = this.localResponse;
        return lr == null ? null : lr.getResponseXML();
    }

    @Override
    public Image getResponseImage() {
        LocalResponse lr = this.localResponse;
        return lr == null ? null : lr.getResponseImage();
    }

    @Override
    public byte[] getResponseBytes() {
        LocalResponse lr = this.localResponse;
        return lr == null ? null : lr.getResponseBytes();
    }

    @Override
    public int getStatus() {
        try {
            LocalResponse lr = this.localResponse;
            return lr == null ? 0 : lr.getStatus();
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    @Override
    public String getStatusText() {
        try {
            LocalResponse lr = this.localResponse;
            return lr == null ? null : lr.getStatusText();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public void abort() {
        RequestHandler rhToDelete = this.currentRequestHandler;
        if (rhToDelete != null) {
            RequestEngine.getInstance().cancelRequest(rhToDelete);
        }
    }

    @Override
    public String getAllResponseHeaders() {
        LocalResponse lr = this.localResponse;
        return lr == null ? null : lr.getAllResponseHeaders();
    }

    @Override
    public String getResponseHeader(String headerName) {
        LocalResponse lr = this.localResponse;
        return lr == null ? null : lr.getResponseHeader(headerName);
    }

    @Override
    public void open(String method, String url) throws IOException {
        this.open(method, url, true);
    }

    @Override
    public void open(String method, URL url) {
        this.open(method, url, true, null, null);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag) {
        this.open(method, url, asyncFlag, null, null);
    }

    @Override
    public void open(String method, String url, boolean asyncFlag) throws IOException {
        URL urlObj = Urls.createURL(null, url);
        this.open(method, urlObj, asyncFlag, null, null);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag, String userName) {
        this.open(method, url, asyncFlag, userName, null);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag, String userName, String password) {
        this.isAsynchronous = asyncFlag;
        this.req.setUsername(userName);
        this.req.setPassword(password);
        this.req.setUrl(url.toString());
        if (method.equalsIgnoreCase(Method.GET.name())) {
            this.req.setMethod(Method.GET);
        } else {
            this.req.setMethod(Method.POST);
        }
        this.changeReadyState(1);
    }

    @Override
    public void send(String content) throws IOException {
        try {
            LocalRequestHandler rhandler = new LocalRequestHandler(new URL(this.req.getUrl()), this.req.getMethod().name(), content);
            this.currentRequestHandler = rhandler;
            try {
                if (this.isAsynchronous) {
                    RequestEngine.getInstance().scheduleRequest(rhandler);
                } else {
                    RequestEngine.getInstance().inlineRequest(rhandler);
                }
            }
            finally {
                this.currentRequestHandler = null;
            }
        }
        catch (Exception err) {
            logger.log(Level.SEVERE, "open()", err);
        }
    }

    @Override
    public void addNetworkRequestListener(final NetworkRequestListener listener) {
        this.READY_STATE_CHANGE.addListener(new GenericEventListener(){

            @Override
            public void processEvent(EventObject event) {
                listener.readyStateChanged((NetworkRequestEvent)event);
            }
        });
    }

    private void changeReadyState(int newState) {
        this.readyState = newState;
        this.READY_STATE_CHANGE.fireEvent(new NetworkRequestEvent(this, newState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(ClientletResponse response) {
        Object cachedResponse;
        if (response.isFromCache() && (cachedResponse = response.getTransientCachedObject()) instanceof CacheableResponse) {
            CacheableResponse cr = (CacheableResponse)cachedResponse;
            this.changeReadyState(1);
            this.localResponse = cr.newLocalResponse(response);
            this.changeReadyState(2);
            this.changeReadyState(3);
            this.changeReadyState(4);
            return;
        }
        try {
            LocalResponse newResponse;
            this.changeReadyState(1);
            this.localResponse = newResponse = new LocalResponse(response);
            this.changeReadyState(2);
            int cl = response.getContentLength();
            InputStream in = response.getInputStream();
            int bufferSize = cl == -1 ? 8192 : Math.min(cl, 8192);
            byte[] buffer = new byte[bufferSize];
            int readSoFar = 0;
            boolean firstTime = true;
            ClientletContext threadContext = ClientletAccess.getCurrentClientletContext();
            NavigatorProgressEvent prevProgress = null;
            if (threadContext != null) {
                prevProgress = threadContext.getProgressEvent();
            }
            try {
                int numRead;
                long lastProgress = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    long currentTime;
                    if (numRead == 0) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("setResponse(): Read zero bytes from " + response.getResponseURL());
                        }
                        break;
                    }
                    readSoFar += numRead;
                    if (threadContext != null && (currentTime = System.currentTimeMillis()) - lastProgress > 500L) {
                        lastProgress = currentTime;
                        threadContext.setProgressEvent(ProgressType.CONTENT_LOADING, readSoFar, cl, response.getResponseURL());
                    }
                    newResponse.writeBytes(buffer, 0, numRead);
                    if (!firstTime) continue;
                    firstTime = false;
                    this.changeReadyState(3);
                }
            }
            finally {
                if (threadContext != null) {
                    threadContext.setProgressEvent(prevProgress);
                }
            }
            newResponse.setComplete(true);
            CacheableResponse cacheable = newResponse.getCacheableResponse();
            if (cacheable != null) {
                response.setNewTransientCachedObject(cacheable, cacheable.getEstimatedSize());
            }
            this.changeReadyState(4);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "setResponse()", ioe);
            this.localResponse = null;
            this.changeReadyState(4);
        }
    }

    public Request getReq() {
        return this.req;
    }

    public void setReq(Request req) {
        this.req = req;
    }

    private static class LocalResponse {
        private final ClientletResponse cresponse;
        private final CacheableResponse cacheable;
        private Map headers;

        public LocalResponse(ClientletResponse response) {
            this.cresponse = response;
            this.cacheable = new CacheableResponse();
        }

        public LocalResponse(ClientletResponse response, CacheableResponse cacheable) {
            this.cresponse = response;
            this.cacheable = cacheable;
        }

        public CacheableResponse getCacheableResponse() {
            CacheableResponse c = this.cacheable;
            if (!c.complete) {
                return null;
            }
            return c;
        }

        public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
            ByteArrayOutputStream out = this.cacheable.buffer;
            if (out == null) {
                out = new ByteArrayOutputStream();
                this.cacheable.buffer = out;
            }
            out.write(bytes, offset, length);
        }

        public void setComplete(boolean complete) {
            this.cacheable.complete = complete;
        }

        public Map getHeaders() {
            Map h = this.headers;
            if (h == null) {
                this.headers = h = this.getHeadersImpl();
            }
            return h;
        }

        private Map getHeadersImpl() {
            HashMap<String, String> headers = new HashMap<String, String>();
            ClientletResponse cresponse = this.cresponse;
            Iterator headerNames = cresponse.getHeaderNames();
            while (headerNames.hasNext()) {
                String[] values;
                String headerName = (String)headerNames.next();
                if (headerName == null || (values = cresponse.getHeaders(headerName)) == null || values.length <= 0) continue;
                headers.put(headerName.toLowerCase(), values[0]);
            }
            return headers;
        }

        public int getStatus() throws IOException {
            return this.cresponse.getResponseCode();
        }

        public String getStatusText() throws IOException {
            return this.cresponse.getResponseMessage();
        }

        public String getResponseHeader(String headerName) {
            return (String)this.getHeaders().get(headerName.toLowerCase());
        }

        public String getAllResponseHeaders() {
            ClientletResponse cresponse = this.cresponse;
            Iterator headerNames = cresponse.getHeaderNames();
            StringBuffer allHeadersBuf = new StringBuffer();
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                if (headerName == null) continue;
                String[] values = cresponse.getHeaders(headerName);
                for (int i = 0; i < values.length; ++i) {
                    allHeadersBuf.append(headerName);
                    allHeadersBuf.append(": ");
                    allHeadersBuf.append(values[i]);
                    allHeadersBuf.append("\r\n");
                }
            }
            return allHeadersBuf.toString();
        }

        public String getResponseText() {
            return this.cacheable.getResponseText(this.cresponse.getCharset());
        }

        public Document getResponseXML() {
            return this.cacheable.getResponseXML();
        }

        public Image getResponseImage() {
            return this.cacheable.getResponseImage();
        }

        public byte[] getResponseBytes() {
            return this.cacheable.getResponseBytes();
        }
    }

    private static class CacheableResponse {
        private WeakReference<Image> imageRef;
        private ByteArrayOutputStream buffer;
        private Document document;
        private String textContent;
        private boolean complete;

        public int getEstimatedSize() {
            ByteArrayOutputStream out = this.buffer;
            int factor = 3;
            return (out == null ? 0 : out.size()) * factor + 512;
        }

        public LocalResponse newLocalResponse(ClientletResponse response) {
            return new LocalResponse(response, this);
        }

        public Image getResponseImage() {
            byte[] bytes;
            Image img;
            WeakReference<Image> imageRef = this.imageRef;
            Image image = img = imageRef == null ? null : (Image)imageRef.get();
            if (img == null && this.complete && (bytes = this.getResponseBytes()) != null) {
                img = Toolkit.getDefaultToolkit().createImage(bytes);
                this.imageRef = new WeakReference<Image>(img);
            }
            return img;
        }

        public String getResponseText(String charset) {
            String responseText = this.textContent;
            if (responseText != null) {
                return responseText;
            }
            byte[] bytes = this.getResponseBytes();
            if (bytes == null) {
                return null;
            }
            try {
                responseText = new String(bytes, charset);
            }
            catch (UnsupportedEncodingException uee) {
                logger.log(Level.WARNING, "getResponseText()", uee);
                try {
                    responseText = new String(bytes, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException uee2) {
                    responseText = null;
                }
            }
            this.textContent = responseText;
            return responseText;
        }

        public byte[] getResponseBytes() {
            ByteArrayOutputStream out = this.buffer;
            return out == null ? null : out.toByteArray();
        }

        public Document getResponseXML() {
            byte[] bytes;
            Document doc = this.document;
            if (doc == null && this.complete && (bytes = this.getResponseBytes()) != null) {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                try {
                    doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                }
                catch (Exception err) {
                    logger.log(Level.SEVERE, "getResponseXML()", err);
                }
                this.document = doc;
            }
            return doc;
        }
    }

    private class LocalRequestHandler
    extends SimpleRequestHandler {
        private final String method;

        public LocalRequestHandler(URL url, String method, String altPostData) {
            super(url, method, altPostData, RequestType.ELEMENT);
            this.method = method;
        }

        @Override
        public String getLatestRequestMethod() {
            return this.method;
        }

        @Override
        public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
            logger.log(Level.WARNING, "handleException(): url=" + this.getLatestRequestURL() + ",response=[" + response + "]", exception);
            return true;
        }

        @Override
        public void processResponse(ClientletResponse response) throws ClientletException, IOException {
            NetworkRequestImpl.this.setResponse(response);
        }
    }
}

