/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;

public class InputCheckboxControl
extends BaseInputControl {
    private static final long serialVersionUID = 1L;
    private final JCheckBox widget;

    public InputCheckboxControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        this.widget = checkBox;
        if (modelNode.getTitle() != null) {
            checkBox.setToolTipText(modelNode.getTitle());
        }
        checkBox.setVisible(modelNode.getHidden());
        checkBox.applyComponentOrientation(this.direction(modelNode.getDir()));
        checkBox.setSelected(this.controlElement.getAttributeAsBoolean("checked"));
        checkBox.setEnabled(!modelNode.getDisabled());
        checkBox.setSelected(modelNode.getChecked());
        this.widget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HtmlController.getInstance().onPressed(InputCheckboxControl.this.controlElement, null, 0, 0);
            }
        });
        this.add(checkBox);
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
    }

    @Override
    public void click() {
        this.widget.doClick();
    }

    @Override
    public boolean getChecked() {
        return this.widget.isSelected();
    }

    @Override
    public void setChecked(boolean checked) {
        this.widget.setSelected(checked);
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    @Override
    public void resetInput() {
        this.widget.setSelected(this.controlElement.getAttributeAsBoolean("checked"));
    }

    @Override
    public String getValue() {
        return this.controlElement.getAttribute("value");
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }
}

