/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.dombl.InputContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLOptionElementImpl;
import org.lobobrowser.html.domimpl.HTMLOptionsCollectionImpl;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.html.w3c.HTMLOptionsCollection;
import org.lobobrowser.html.w3c.HTMLSelectElement;
import org.lobobrowser.html.w3c.ValidityState;
import org.mozilla.javascript.Function;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;

public class HTMLSelectElementImpl
extends HTMLBaseInputElement
implements HTMLSelectElement {
    private Boolean multipleState = null;
    private HTMLOptionsCollection options;
    private int deferredSelectedIndex = -1;
    private Function onchange;

    public HTMLSelectElementImpl(String name) {
        super(name);
    }

    @Override
    public void add(HTMLElement element, HTMLElement before) throws DOMException {
        this.insertBefore(element, before);
    }

    @Override
    public int getLength() {
        return this.getOptions().getLength();
    }

    @Override
    public boolean getMultiple() {
        Boolean m = this.multipleState;
        if (m != null) {
            return m;
        }
        return this.getAttributeAsBoolean("multiple");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLOptionsCollection getOptions() {
        HTMLSelectElementImpl hTMLSelectElementImpl = this;
        synchronized (hTMLSelectElementImpl) {
            if (this.options == null) {
                this.options = new HTMLOptionsCollectionImpl(this);
            }
            return this.options;
        }
    }

    @Override
    public int getSelectedIndex() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            return ic.getSelectedIndex();
        }
        return this.deferredSelectedIndex;
    }

    @Override
    public int getSize() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            return ic.getVisibleSize();
        }
        return 0;
    }

    @Override
    public String getType() {
        return this.getMultiple() ? "select-multiple" : "select-one";
    }

    @Override
    public void remove(int index) {
        try {
            this.removeChild(this.getOptions().item(index));
        }
        catch (DOMException de) {
            this.warn("remove(): Unable to remove option at index " + index + ".", de);
        }
    }

    @Override
    public void setLength(int length) throws DOMException {
        this.getOptions().setLength(length);
    }

    @Override
    public void setMultiple(boolean multiple) {
        boolean prevMultiple = this.getMultiple();
        this.multipleState = multiple;
        if (prevMultiple != multiple) {
            this.informLayoutInvalid();
        }
    }

    @Override
    public void setSelectedIndex(int selectedIndex) {
        this.setSelectedIndexImpl(selectedIndex);
        HTMLOptionsCollection options = this.getOptions();
        int length = options.getLength();
        for (int i = 0; i < length; ++i) {
            HTMLOptionElementImpl option = (HTMLOptionElementImpl)options.item(i);
            option.setSelectedImpl(i == selectedIndex);
        }
    }

    void setSelectedIndexImpl(int selectedIndex) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setSelectedIndex(selectedIndex);
        } else {
            this.deferredSelectedIndex = selectedIndex;
        }
    }

    @Override
    public void setSize(int size) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setVisibleSize(size);
        }
    }

    @Override
    protected FormInput[] getFormInputs() {
        String name;
        String[] values;
        InputContext ic = this.inputContext;
        String[] stringArray = values = ic == null ? null : ic.getValues();
        if (values == null) {
            String[] stringArray2;
            String value = this.getValue();
            if (value == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = value;
            }
            values = stringArray2;
            if (values == null) {
                return null;
            }
        }
        if ((name = this.getName()) == null) {
            return null;
        }
        ArrayList<FormInput> formInputs = new ArrayList<FormInput>();
        for (int i = 0; i < values.length; ++i) {
            formInputs.add(new FormInput(name, values[i]));
        }
        return formInputs.toArray(FormInput.EMPTY_ARRAY);
    }

    @Override
    public void resetInput() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.resetInput();
        }
    }

    @Override
    public void setInputContext(InputContext ic) {
        super.setInputContext(ic);
        if (ic != null) {
            ic.setSelectedIndex(this.deferredSelectedIndex);
        }
    }

    public Function getOnchange() {
        return this.getEventFunction(this.onchange, "onchange");
    }

    public void setOnchange(Function value) {
        this.onchange = value;
    }

    @Override
    public boolean getAutofocus() {
        String auto = this.getAttribute("autofocus");
        return "autofocus".equalsIgnoreCase(auto);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        this.setAttribute("autofocus", autofocus ? "autofocus" : null);
    }

    @Override
    public Object item(int index) {
        return null;
    }

    @Override
    public Object namedItem(String name) {
        return null;
    }

    @Override
    public void add(HTMLElement element) {
    }

    @Override
    public void add(HTMLElement element, int before) {
    }

    @Override
    public HTMLCollection getSelectedOptions() {
        return null;
    }

    @Override
    public boolean getWillValidate() {
        return false;
    }

    @Override
    public ValidityState getValidity() {
        return null;
    }

    @Override
    public String getValidationMessage() {
        return null;
    }

    @Override
    public boolean checkValidity() {
        return false;
    }

    @Override
    public void setCustomValidity(String error) {
    }

    @Override
    public NodeList getLabels() {
        return null;
    }
}

