/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.DOMImplementationImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.http.SSLCertificate;
import org.lobobrowser.util.Urls;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private static final Logger logger = Logger.getLogger(DocumentBuilderImpl.class.getName());
    private EntityResolver resolver;
    private ErrorHandler errorHandler;
    private final UserAgentContext bcontext;
    private final HtmlRendererContext rcontext;
    private DOMImplementation domImplementation;

    public DocumentBuilderImpl(UserAgentContext context) {
        this.rcontext = null;
        this.bcontext = context;
    }

    public DocumentBuilderImpl(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        this.rcontext = rcontext;
        this.bcontext = ucontext;
    }

    public DocumentBuilderImpl(HtmlRendererContext rcontext) {
        this.rcontext = rcontext;
        this.bcontext = rcontext.getUserAgentContext();
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.createDocument(is);
        document.load();
        return document;
    }

    public Document createDocument(InputSource is) throws SAXException, IOException {
        WritableLineReader wis;
        Reader reader;
        String uri;
        String encoding = is.getEncoding();
        String charset = encoding;
        if (charset == null) {
            charset = "US-ASCII";
        }
        if ((uri = is.getSystemId()) == null) {
            logger.warning("parse(): InputSource has no SystemId (URI); document item URLs will not be resolvable.");
        }
        if ((reader = is.getCharacterStream()) != null) {
            wis = new WritableLineReader(reader);
        } else {
            InputStream in = is.getByteStream();
            if (in != null) {
                wis = new WritableLineReader(new InputStreamReader(in, charset));
            } else if (uri != null) {
                SSLCertificate.setCertificate();
                URLConnection connection = new URL(uri).openConnection();
                in = connection.getInputStream();
                if (encoding == null) {
                    charset = Urls.getCharset(connection);
                }
                wis = new WritableLineReader(new InputStreamReader(in, charset));
            } else {
                throw new IllegalArgumentException("The InputSource must have either a reader, an input stream or a URI.");
            }
        }
        HTMLDocumentImpl document = new HTMLDocumentImpl(this.bcontext, this.rcontext, wis, uri);
        return document;
    }

    @Override
    public boolean isNamespaceAware() {
        return false;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.resolver = er;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    @Override
    public Document newDocument() {
        return new HTMLDocumentImpl(this.bcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOMImplementation getDOMImplementation() {
        DocumentBuilderImpl documentBuilderImpl = this;
        synchronized (documentBuilderImpl) {
            if (this.domImplementation == null) {
                this.domImplementation = new DOMImplementationImpl(this.bcontext);
            }
            return this.domImplementation;
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }
}

