/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderstate;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;

public class ImageRenderState
extends StyleSheetRenderState {
    public ImageRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    @Override
    public HtmlInsets getMarginInsets() {
        HtmlInsets mi = this.marginInsets;
        if (mi != INVALID_INSETS) {
            return mi;
        }
        AbstractCSS2Properties props = this.getCssProperties();
        mi = props == null ? null : HtmlValues.getMarginInsets(props, this);
        if (mi == null) {
            String vspaceText;
            int hspace = 0;
            int vspace = 0;
            boolean createNew = false;
            String hspaceText = this.element.getAttribute("hspace");
            if (hspaceText != null && hspaceText.length() != 0) {
                createNew = true;
                try {
                    hspace = Integer.parseInt(hspaceText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((vspaceText = this.element.getAttribute("vspace")) != null && vspaceText.length() != 0) {
                createNew = true;
                try {
                    vspace = Integer.parseInt(vspaceText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (createNew) {
                mi = new HtmlInsets();
                mi.top = vspace;
                mi.topType = 1;
                mi.bottom = vspace;
                mi.bottomType = 1;
                mi.left = hspace;
                mi.leftType = 1;
                mi.right = hspace;
                mi.rightType = 1;
            }
        }
        this.marginInsets = mi;
        return mi;
    }

    @Override
    public BorderInfo getBorderInfo() {
        BorderInfo binfo = this.borderInfo;
        if (binfo != INVALID_BORDER_INFO) {
            return binfo;
        }
        binfo = super.getBorderInfo();
        if (binfo == null || binfo.getTopStyle() == 0 && binfo.getBottomStyle() == 0 && binfo.getLeftStyle() == 0 && binfo.getRightStyle() == 0) {
            String border;
            HTMLElementImpl element;
            if (binfo == null) {
                binfo = new BorderInfo();
            }
            if ((element = this.element) != null && (border = element.getAttribute("border")) != null) {
                int value;
                int valueType;
                if ((border = border.trim()).endsWith("%")) {
                    valueType = 3;
                    try {
                        value = Integer.parseInt(border.substring(0, border.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                } else {
                    valueType = 1;
                    try {
                        value = Integer.parseInt(border);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                }
                HtmlInsets borderInsets = new HtmlInsets();
                borderInsets.right = borderInsets.bottom = value;
                borderInsets.left = borderInsets.bottom;
                borderInsets.top = borderInsets.bottom;
                borderInsets.rightType = borderInsets.bottomType = valueType;
                borderInsets.leftType = borderInsets.bottomType;
                borderInsets.topType = borderInsets.bottomType;
                binfo.setInsets(borderInsets);
                if (binfo.getTopColor() == null) {
                    binfo.setTopColor(Color.BLACK);
                }
                if (binfo.getLeftColor() == null) {
                    binfo.setLeftColor(Color.BLACK);
                }
                if (binfo.getRightColor() == null) {
                    binfo.setRightColor(Color.BLACK);
                }
                if (binfo.getBottomColor() == null) {
                    binfo.setBottomColor(Color.BLACK);
                }
                if (value != 0) {
                    binfo.setTopStyle(4);
                    binfo.setLeftStyle(4);
                    binfo.setRightStyle(4);
                    binfo.setBottomStyle(4);
                }
            }
        }
        this.borderInfo = binfo;
        return binfo;
    }
}

