/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ClientletSelector;
import org.lobobrowser.primary.clientlets.TextClientlet;
import org.lobobrowser.primary.clientlets.download.DownloadClientlet;
import org.lobobrowser.primary.clientlets.html.HtmlClientlet;
import org.lobobrowser.primary.clientlets.img.ImageClientlet;
import org.lobobrowser.primary.clientlets.pdf.PdfClientlet;

public class PrimaryClientletSelector
implements ClientletSelector {
    private static final Logger logger = Logger.getLogger(PrimaryClientletSelector.class.getName());

    @Override
    public Clientlet select(ClientletRequest request, ClientletResponse response) {
        String mimeTypeTL;
        String mimeType = response.getMimeType();
        System.out.println("mimeType: " + mimeType);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("select(): mimeType=" + mimeType);
        }
        String string = mimeTypeTL = mimeType == null ? null : mimeType.toLowerCase();
        if ("text/html".equals(mimeTypeTL)) {
            return new HtmlClientlet();
        }
        if ("image/jpeg".equals(mimeTypeTL) || "image/jpg".equals(mimeTypeTL) || "image/gif".equals(mimeTypeTL) || "image/png".equals(mimeTypeTL) || "image/svg+xml".equals(mimeTypeTL)) {
            return new ImageClientlet();
        }
        if (mimeType == null || "application/octet-stream".equals(mimeTypeTL) || "content/unknown".equals(mimeTypeTL)) {
            String path = response.getResponseURL().getPath();
            int lastDotIdx = path.lastIndexOf(46);
            String extension = lastDotIdx == -1 ? "" : path.substring(lastDotIdx + 1);
            String extensionTL = extension.toLowerCase();
            if ("html".equals(extensionTL) || "htm".equals(extensionTL) || extensionTL.length() == 0) {
                return new HtmlClientlet();
            }
            if ("gif".equals(extensionTL) || "jpg".equals(extensionTL) || "png".equals(extensionTL) || "svg".equals(extensionTL)) {
                return new ImageClientlet();
            }
            return null;
        }
        return null;
    }

    @Override
    public Clientlet lastResortSelect(ClientletRequest request, ClientletResponse response) {
        String mimeType = response.getMimeType();
        String mimeTypeTL = mimeType == null ? null : mimeType.toLowerCase();
        System.out.println("mtttl2: " + mimeTypeTL);
        if (mimeTypeTL != null && mimeTypeTL.startsWith("text/")) {
            return new TextClientlet();
        }
        if ("application/xml".equals(mimeTypeTL)) {
            return new HtmlClientlet();
        }
        String path = response.getResponseURL().getPath();
        int lastDotIdx = path.lastIndexOf(46);
        String extension = lastDotIdx == -1 ? "" : path.substring(lastDotIdx + 1);
        String extensionTL = extension.toLowerCase();
        if ("xhtml".equals(extensionTL)) {
            return new HtmlClientlet();
        }
        if ("txt".equals(extensionTL) || "xml".equals(extensionTL) || "js".equals(extensionTL) || "rss".equals(extensionTL) || "xaml".equals(extensionTL) || "css".equals(extensionTL)) {
            return new TextClientlet();
        }
        if ("pdf".equals(extensionTL)) {
            return new PdfClientlet();
        }
        if (mimeType == null) {
            return new HtmlClientlet();
        }
        return new DownloadClientlet();
    }
}

