/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.img;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class ImageScrollable
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private final Image image;
    private int imageWidth = -1;
    private int imageHeight = -1;

    public ImageScrollable(Image img) {
        this.image = img;
        int w = img.getWidth(this);
        int h = img.getHeight(this);
        this.imageWidth = w;
        this.imageHeight = h;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            this.imageWidth = img.getWidth(this);
            this.imageHeight = img.getHeight(this);
            this.revalidate();
            this.repaint();
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int x = (this.getWidth() - this.imageWidth) / 2;
        int y = (this.getHeight() - this.imageHeight) / 2;
        g.drawImage(this.image, x, y, this.imageWidth, this.imageHeight, this);
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.imageWidth;
        int h = this.imageHeight;
        return new Dimension(w == -1 ? 0 : w, h == -1 ? 0 : h);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 12;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int orientation, int direction) {
        if (orientation == 0) {
            return arg0.width;
        }
        return arg0.height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

