/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lobobrowser.primary.action.BackAction;
import org.lobobrowser.primary.action.BackMoreAction;
import org.lobobrowser.primary.action.BookmarkNavigateAction;
import org.lobobrowser.primary.action.EnableableAction;
import org.lobobrowser.primary.action.ForwardAction;
import org.lobobrowser.primary.action.ForwardMoreAction;
import org.lobobrowser.primary.action.GoToAction;
import org.lobobrowser.primary.action.NavigateAction;
import org.lobobrowser.primary.action.RecentHostsAction;
import org.lobobrowser.primary.action.ReloadAction;
import org.lobobrowser.primary.action.SourceAction;
import org.lobobrowser.primary.action.UrlPrefixNavigateAction;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigatorWindow;

public class ActionPool
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ActionPool.class.getName());
    private final ComponentSource componentSource;
    private final NavigatorWindow window;
    private final Collection<EnableableAction> enableableActions;

    public ActionPool(ComponentSource componentSource, NavigatorWindow window) {
        this.componentSource = componentSource;
        this.window = window;
        LinkedList<EnableableAction> actions = new LinkedList<EnableableAction>();
        this.enableableActions = actions;
        actions.add(new BackAction(componentSource, window, this));
        actions.add(new ForwardAction(componentSource, window, this));
        actions.add(new ReloadAction(componentSource, window, this));
        actions.add(new BackMoreAction(componentSource, window, this));
        actions.add(new ForwardMoreAction(componentSource, window, this));
        actions.add(new RecentHostsAction(componentSource, window, this));
        actions.add(new SourceAction(componentSource, window, this));
    }

    public void updateEnabling() {
        for (EnableableAction action : this.enableableActions) {
            action.updateEnabling();
        }
    }

    public Action createNavigateAction(String fullURL) {
        URL url;
        try {
            url = new URL(fullURL);
        }
        catch (MalformedURLException mfu) {
            logger.log(Level.WARNING, "createNavigateAction()", mfu);
            url = null;
        }
        NavigateAction nav = new NavigateAction(this.componentSource, this.window);
        nav.setUrl(url);
        return nav;
    }

    public Action createNavigateAction(URL url) {
        NavigateAction nav = new NavigateAction(this.componentSource, this.window);
        nav.setUrl(url);
        return nav;
    }

    public Action createBookmarkNavigateAction(URL url) {
        BookmarkNavigateAction bookNav = new BookmarkNavigateAction(this.componentSource, this.window);
        bookNav.setUrl(url);
        return bookNav;
    }

    public Action createGoToAction(NavigationEntry entry) {
        GoToAction go = new GoToAction(this.componentSource, this.window);
        go.setEntry(entry);
        return go;
    }

    public Action addUrlPrefixNavigateAction(String urlPrefix, boolean urlEncode) {
        UrlPrefixNavigateAction urlPrefixNav = new UrlPrefixNavigateAction(this.componentSource, this.window, this);
        urlPrefixNav.setUrlPrefix(urlPrefix);
        urlPrefixNav.setUrlEncode(urlEncode);
        this.enableableActions.add(urlPrefixNav);
        return urlPrefixNav;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }
}

