/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.download;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.gui.DefaultWindowFactory;
import org.lobobrowser.primary.gui.FieldType;
import org.lobobrowser.primary.gui.FormField;
import org.lobobrowser.primary.gui.FormPanel;
import org.lobobrowser.primary.settings.ToolsSettings;
import org.lobobrowser.request.AbstractRequestHandler;
import org.lobobrowser.request.ClientletRequestImpl;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.util.OS;
import org.lobobrowser.util.Timing;

public class DownloadDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DownloadDialog.class.getName());
    private final JProgressBar progressBar = new JProgressBar();
    private final FormPanel bottomFormPanel = new FormPanel();
    private final FormPanel topFormPanel = new FormPanel();
    private final FormField documentField = new FormField(FieldType.TEXT, false);
    private final FormField sizeField = new FormField(FieldType.TEXT, false);
    private final FormField destinationField = new FormField(FieldType.TEXT, false);
    private final FormField timeLeftField = new FormField(FieldType.TEXT, false);
    private final FormField mimeTypeField = new FormField(FieldType.TEXT, false);
    private final FormField transferRateField = new FormField(FieldType.TEXT, false);
    private final FormField transferSizeField = new FormField(FieldType.TEXT, false);
    private final JButton saveButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JButton openFolderButton = new JButton();
    private final JButton openButton = new JButton();
    private final URL url;
    private final int knownContentLength;
    private RequestHandler requestHandler;
    private File destinationFile;
    private long downloadBaseTimestamp;
    private long lastTimestamp;
    private long lastProgressValue;
    private double lastTransferRate = Double.NaN;

    public DownloadDialog(ClientletResponse response, URL url, int transferSpeed) {
        int cl;
        this.url = url;
        this.setIconImage(DefaultWindowFactory.getInstance().getDefaultImageIcon().getImage());
        this.topFormPanel.setMinLabelWidth(100);
        this.bottomFormPanel.setMinLabelWidth(100);
        this.bottomFormPanel.setEnabled(false);
        this.documentField.setCaption("Document:");
        this.timeLeftField.setCaption("Estimated time:");
        this.mimeTypeField.setCaption("MIME type:");
        this.sizeField.setCaption("Size:");
        this.destinationField.setCaption("File:");
        this.transferSizeField.setCaption("Transfer size:");
        this.transferRateField.setCaption("Transfer rate:");
        this.openFolderButton.setVisible(false);
        this.openButton.setVisible(false);
        this.documentField.setValue(url.toExternalForm());
        this.mimeTypeField.setValue(response.getMimeType());
        this.knownContentLength = cl = response.getContentLength();
        String sizeText = cl == -1 ? "Not known" : DownloadDialog.getSizeText(cl);
        this.sizeField.setValue(sizeText);
        String estTimeText = transferSpeed <= 0 || cl == -1 ? "Not known" : Timing.getElapsedText(cl / transferSpeed);
        this.timeLeftField.setValue(estTimeText);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new FlowLayout());
        Box rootPanel = new Box(1);
        rootPanel.setBorder(new EmptyBorder(4, 8, 4, 8));
        rootPanel.add(this.progressBar);
        rootPanel.add(Box.createVerticalStrut(8));
        rootPanel.add(this.topFormPanel);
        rootPanel.add(Box.createVerticalStrut(8));
        rootPanel.add(this.bottomFormPanel);
        rootPanel.add(Box.createVerticalStrut(8));
        rootPanel.add(this.getButtonsPanel());
        contentPane.add(rootPanel);
        FormPanel bfp = this.bottomFormPanel;
        bfp.addField(this.destinationField);
        bfp.addField(this.transferRateField);
        bfp.addField(this.transferSizeField);
        FormPanel tfp = this.topFormPanel;
        tfp.addField(this.documentField);
        tfp.addField(this.mimeTypeField);
        tfp.addField(this.sizeField);
        tfp.addField(this.timeLeftField);
        Dimension topPanelPs = this.topFormPanel.getPreferredSize();
        this.topFormPanel.setPreferredSize(new Dimension(400, topPanelPs.height));
        Dimension bottomPanelPs = this.bottomFormPanel.getPreferredSize();
        this.bottomFormPanel.setPreferredSize(new Dimension(400, bottomPanelPs.height));
        this.progressBar.setEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RequestHandler rh = DownloadDialog.this.requestHandler;
                if (rh != null) {
                    rh.cancel();
                    DownloadDialog.this.requestHandler = null;
                }
            }
        });
    }

    private Component getButtonsPanel() {
        JButton saveButton = this.saveButton;
        saveButton.setAction(new SaveAction());
        saveButton.setText("Save As...");
        saveButton.setToolTipText("You must select a file before download begins.");
        JButton closeButton = this.closeButton;
        closeButton.setAction(new CloseAction());
        closeButton.setText("Cancel");
        JButton openButton = this.openButton;
        openButton.setAction(new OpenAction());
        openButton.setText("Open");
        JButton openFolderButton = this.openFolderButton;
        openFolderButton.setAction(new OpenFolderAction());
        openFolderButton.setText("Open Folder");
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(openButton);
        box.add(Box.createHorizontalStrut(4));
        box.add(openFolderButton);
        box.add(Box.createHorizontalStrut(4));
        box.add(saveButton);
        box.add(Box.createHorizontalStrut(4));
        box.add(closeButton);
        return box;
    }

    private void selectFile() {
        String path = this.url.getPath();
        int lastSlashIdx = path.lastIndexOf(47);
        String tentativeName = lastSlashIdx == -1 ? path : path.substring(lastSlashIdx + 1);
        JFileChooser chooser = new JFileChooser();
        ToolsSettings settings = ToolsSettings.getInstance();
        File directory = settings.getDownloadDirectory();
        if (directory != null) {
            File selectedFile = new File(directory, tentativeName);
            chooser.setSelectedFile(selectedFile);
        }
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "The file exists. Are you sure you want to overwrite it?", "Confirm", 0) != 0) {
                return;
            }
            settings.setDownloadDirectory(file.getParentFile());
            settings.save();
            this.startDownload(chooser.getSelectedFile());
        }
    }

    private void startDownload(File file) {
        this.saveButton.setEnabled(false);
        this.timeLeftField.setCaption("Time left:");
        this.destinationField.setValue(file.getName());
        this.destinationField.setToolTip(file.getAbsolutePath());
        this.bottomFormPanel.setEnabled(true);
        this.bottomFormPanel.revalidate();
        ClientletRequestImpl request = new ClientletRequestImpl(this.url, RequestType.DOWNLOAD);
        DownloadRequestHandler handler = new DownloadRequestHandler(request, this, file);
        this.destinationFile = file;
        this.requestHandler = handler;
        this.downloadBaseTimestamp = System.currentTimeMillis();
        Thread t = new Thread((Runnable)new DownloadRunnable(handler), "Download:" + this.url.toExternalForm());
        t.setDaemon(true);
        t.start();
    }

    private void doneWithDownload_Safe(final long totalSize) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadDialog.this.doneWithDownload(totalSize);
            }
        });
    }

    private void doneWithDownload(long totalSize) {
        this.requestHandler = null;
        this.setTitle(this.destinationField.getValue());
        this.timeLeftField.setCaption("Download time:");
        long elapsed = System.currentTimeMillis() - this.downloadBaseTimestamp;
        this.timeLeftField.setValue(Timing.getElapsedText(elapsed));
        String sizeText = DownloadDialog.getSizeText(totalSize);
        this.transferSizeField.setValue(sizeText);
        this.sizeField.setValue(sizeText);
        if (elapsed > 0L) {
            double transferRate = (double)totalSize / (double)elapsed;
            this.transferRateField.setValue(DownloadDialog.round1(transferRate) + " Kb/sec");
        } else {
            this.transferRateField.setValue("N/A");
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(100);
        this.progressBar.setMaximum(100);
        this.progressBar.setString("Done.");
        this.closeButton.setText("Close");
        if (OS.supportsLaunchPath()) {
            this.saveButton.setVisible(false);
            this.openFolderButton.setVisible(true);
            this.openButton.setVisible(true);
            this.openButton.revalidate();
        }
    }

    private void errorInDownload_Safe() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadDialog.this.errorInDownload();
            }
        });
    }

    private void errorInDownload() {
        if (this.requestHandler != null) {
            JOptionPane.showMessageDialog(this, "An error occurred while trying to download the file.");
            this.dispose();
        }
    }

    private static double round1(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    private static String getSizeText(long numBytes) {
        if (numBytes < 1024L) {
            return numBytes + " bytes";
        }
        double numK = (double)numBytes / 1024.0;
        if (numK < 1024.0) {
            return DownloadDialog.round1(numK) + " Kb";
        }
        double numM = numK / 1024.0;
        if (numM < 1024.0) {
            return DownloadDialog.round1(numM) + " Mb";
        }
        double numG = numM / 1024.0;
        return DownloadDialog.round1(numG) + " Gb";
    }

    private void updateProgress_Safe(final ProgressType progressType, final int value, final int max) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadDialog.this.updateProgress(progressType, value, max);
            }
        });
    }

    private void updateProgress(ProgressType progressType, int value, int max) {
        String sizeText = DownloadDialog.getSizeText(value);
        this.transferSizeField.setValue(sizeText);
        long newTimestamp = System.currentTimeMillis();
        double lastTransferRate = this.lastTransferRate;
        long lastProgressValue = this.lastProgressValue;
        long lastTimestamp = this.lastTimestamp;
        long elapsed = newTimestamp - lastTimestamp;
        double newTransferRate = Double.NaN;
        if (elapsed > 0L) {
            newTransferRate = ((long)value - lastProgressValue) / elapsed;
            if (!Double.isNaN(lastTransferRate)) {
                newTransferRate = (newTransferRate + lastTransferRate * 5.0) / 6.0;
            }
        }
        if (!Double.isNaN(newTransferRate)) {
            this.transferRateField.setValue(DownloadDialog.round1(newTransferRate) + " Kb/sec");
            int cl = this.knownContentLength;
            if (cl > 0 && newTransferRate > 0.0) {
                this.timeLeftField.setValue(Timing.getElapsedText((long)((double)(cl - value) / newTransferRate)));
            }
        }
        this.lastTimestamp = newTimestamp;
        this.lastProgressValue = value;
        this.lastTransferRate = newTransferRate;
        JProgressBar pb = this.progressBar;
        if (progressType == ProgressType.CONNECTING) {
            pb.setIndeterminate(true);
            pb.setStringPainted(true);
            pb.setString("Connecting...");
            this.setTitle(this.destinationField.getValue() + ": Connecting...");
        } else if (max <= 0) {
            pb.setIndeterminate(true);
            pb.setStringPainted(false);
            this.setTitle(sizeText + " " + this.destinationField.getValue());
        } else {
            int percent = value * 100 / max;
            pb.setIndeterminate(false);
            pb.setStringPainted(true);
            pb.setMaximum(max);
            pb.setValue(value);
            String percentText = percent + "%";
            pb.setString(percentText);
            this.setTitle(percentText + " " + this.destinationField.getValue());
        }
    }

    private class DownloadRequestHandler
    extends AbstractRequestHandler {
        private final File file;
        private boolean downloadDone;
        private long lastProgressUpdate;

        public DownloadRequestHandler(ClientletRequest request, Component dialogComponent, File file) {
            super(request, dialogComponent);
            this.downloadDone = false;
            this.lastProgressUpdate = 0L;
            this.file = file;
        }

        @Override
        public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
            logger.log(Level.WARNING, "An error occurred trying to download " + response.getResponseURL() + " to " + this.file + ".", exception);
            DownloadDialog.this.errorInDownload_Safe();
            return true;
        }

        @Override
        public void handleProgress(ProgressType progressType, URL url, String method, int value, int max) {
            long timestamp;
            if (!this.downloadDone && (timestamp = System.currentTimeMillis()) - this.lastProgressUpdate > 1000L) {
                DownloadDialog.this.updateProgress_Safe(progressType, value, max);
                this.lastProgressUpdate = timestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processResponse(ClientletResponse response) throws ClientletException, IOException {
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                InputStream in = response.getInputStream();
                try {
                    int numRead;
                    int totalRead = 0;
                    byte[] buffer = new byte[8192];
                    while ((numRead = in.read(buffer)) != -1) {
                        if (this.isCancelled()) {
                            throw new IOException("cancelled");
                        }
                        totalRead += numRead;
                        ((OutputStream)out).write(buffer, 0, numRead);
                    }
                    this.downloadDone = true;
                    DownloadDialog.this.doneWithDownload_Safe(totalRead);
                }
                finally {
                    in.close();
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
    }

    private class DownloadRunnable
    implements Runnable {
        private final RequestHandler handler;

        public DownloadRunnable(RequestHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                RequestEngine.getInstance().inlineRequest(this.handler);
            }
            catch (Exception err) {
                logger.log(Level.SEVERE, "Unexpected error on download of [" + DownloadDialog.this.url.toExternalForm() + "].", err);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DownloadDialog.this.dispose();
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = DownloadDialog.this.destinationFile;
            if (file != null) {
                try {
                    OS.launchPath(file.getAbsolutePath());
                    DownloadDialog.this.dispose();
                }
                catch (Exception thrown) {
                    logger.log(Level.WARNING, "Unable to open file: " + file + ".", thrown);
                    JOptionPane.showMessageDialog(DownloadDialog.this, "An error occurred trying to open the file.");
                }
            }
        }
    }

    private class OpenFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OpenFolderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = DownloadDialog.this.destinationFile;
            if (file != null) {
                try {
                    OS.launchPath(file.getParentFile().getAbsolutePath());
                }
                catch (Exception thrown) {
                    logger.log(Level.WARNING, "Unable to open folder of file: " + file + ".", thrown);
                    JOptionPane.showMessageDialog(DownloadDialog.this, "An error occurred trying to open the folder.");
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DownloadDialog.this.selectFile();
        }
    }
}

