/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.prefs;

import java.awt.Component;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.lobobrowser.primary.gui.AbstractItemEditor;
import org.lobobrowser.primary.gui.ItemEditorFactory;
import org.lobobrowser.primary.gui.ItemListControl;
import org.lobobrowser.primary.gui.SwingTasks;
import org.lobobrowser.primary.gui.prefs.AbstractSettingsUI;
import org.lobobrowser.primary.gui.prefs.SearchEngineEditor;
import org.lobobrowser.primary.settings.SearchEngine;
import org.lobobrowser.primary.settings.ToolsSettings;

public class ToolsSettingsUI
extends AbstractSettingsUI {
    private static final long serialVersionUID = 1L;
    private final ToolsSettings settings = ToolsSettings.getInstance();
    private final ItemListControl<SearchEngine> searchEngineListControl;

    public ToolsSettingsUI() {
        ItemEditorFactory<SearchEngine> factory = new ItemEditorFactory<SearchEngine>(){

            @Override
            public AbstractItemEditor<SearchEngine> createItemEditor() {
                return new SearchEngineEditor();
            }
        };
        this.searchEngineListControl = new ItemListControl<SearchEngine>(factory);
        this.searchEngineListControl.setEditorCaption("Please enter search engine information below.");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getSearchEnginePane());
        this.add(SwingTasks.createVerticalFill());
        this.loadSettings();
    }

    private Component getSearchEnginePane() {
        Box innerBox = new Box(0);
        innerBox.add(new JLabel("Search Engines:"));
        innerBox.add(this.searchEngineListControl);
        Box groupBox = SwingTasks.createGroupBox(1, "Search");
        groupBox.add(innerBox);
        return groupBox;
    }

    @Override
    public void restoreDefaults() {
        this.settings.restoreDefaults();
        this.loadSettings();
    }

    @Override
    public void save() {
        ToolsSettings settings = this.settings;
        Collection<SearchEngine> items = this.searchEngineListControl.getItems();
        settings.setSearchEngines(items);
        settings.save();
    }

    private void loadSettings() {
        ToolsSettings settings = this.settings;
        this.searchEngineListControl.setItems(settings.getSearchEngines());
    }
}

