/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.request.VerifiedHostsStore;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;

public abstract class AbstractRequestHandler
implements RequestHandler {
    protected final ClientletRequest request;
    protected final RequestType requestType;
    private final Component dialogComponent;
    private boolean cancelled = false;

    public AbstractRequestHandler(ClientletRequest request, Component dialogComponent) {
        this.request = request;
        this.requestType = request.getRequestType();
        this.dialogComponent = dialogComponent;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return new LocalHostnameVerifier();
    }

    @Override
    public String getLatestRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public URL getLatestRequestURL() {
        return this.request.getRequestURL();
    }

    @Override
    public ClientletRequest getRequest() {
        return this.request;
    }

    @Override
    public abstract boolean handleException(ClientletResponse var1, Throwable var2) throws ClientletException;

    @Override
    public abstract void handleProgress(ProgressType var1, URL var2, String var3, int var4, int var5);

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isNewNavigationEntry() {
        return false;
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public abstract void processResponse(ClientletResponse var1) throws ClientletException, IOException;

    private class LocalHostnameVerifier
    implements HostnameVerifier {
        private boolean verified;

        private LocalHostnameVerifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verify(final String host, SSLSession arg1) {
            this.verified = false;
            final VerifiedHostsStore vhs = VerifiedHostsStore.getInstance();
            if (vhs.contains(host)) {
                return true;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean verified = false;
                        Component dc = AbstractRequestHandler.this.dialogComponent;
                        if (dc != null) {
                            int result = JOptionPane.showConfirmDialog(dc, "Host " + host + " does not match SSL certificate or CA not recognized. Proceed anyway?", "Security Warning", 0);
                            boolean bl = verified = result == 0;
                            if (verified) {
                                vhs.add(host);
                            }
                        }
                        LocalHostnameVerifier localHostnameVerifier = LocalHostnameVerifier.this;
                        synchronized (localHostnameVerifier) {
                            LocalHostnameVerifier.this.verified = verified;
                        }
                    }
                });
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalStateException(ite.getCause());
            }
            LocalHostnameVerifier localHostnameVerifier = this;
            synchronized (localHostnameVerifier) {
                return this.verified;
            }
        }
    }
}

