/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.awt.Frame;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.lobobrowser.gui.AuthenticationDialog;
import org.lobobrowser.settings.AssociatedSettings;
import org.lobobrowser.settings.ConnectionSettings;
import org.lobobrowser.util.gui.GUITasks;

public class AuthenticatorImpl
extends Authenticator {
    private final ConnectionSettings connectionSettings = ConnectionSettings.getInstance();
    private final AssociatedSettings associatedSettings = AssociatedSettings.getInstance();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Authenticator.RequestorType requestorType = this.getRequestorType();
        if (requestorType == Authenticator.RequestorType.PROXY) {
            try {
                PasswordAuthentication pa = this.connectionSettings.getPasswordAuthentication();
                if (pa != null) {
                    return pa;
                }
            }
            catch (Exception err) {
                throw new IllegalStateException(err);
            }
        }
        AssociatedSettings settings = this.associatedSettings;
        String userName = settings.getUserNameForHost(this.getRequestingHost());
        Frame frame = GUITasks.getTopFrame();
        AuthenticationDialog dialog = new AuthenticationDialog(frame);
        if (userName != null) {
            dialog.setUserName(userName);
        }
        dialog.setModal(true);
        dialog.setTitle("Authentication Required");
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.setVisible(true);
        PasswordAuthentication pa = dialog.getAuthentication();
        if (pa != null) {
            settings.setUserNameForHost(this.getRequestingHost(), pa.getUserName());
            settings.save();
        }
        return pa;
    }
}

