/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.CacheFileInfo;
import org.lobobrowser.store.CacheInfo;
import org.lobobrowser.store.CacheStoreInfo;
import org.lobobrowser.store.StorageManager;
import org.lobobrowser.util.LRUCache;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.IORoutines;

public final class CacheManager
implements Runnable {
    private static final Logger logger = Logger.getLogger(CacheManager.class.getName());
    private static final int AFTER_SWEEP_SLEEP = 300000;
    private static final int INITIAL_SLEEP = 30000;
    private static final int DELETE_TOLERANCE = 60000;
    private static final long MAX_CACHE_SIZE = 100000000L;
    private final LRUCache transientCache = new LRUCache(1000000);
    private static CacheManager instance;

    private CacheManager() {
        Thread t = new Thread((Runnable)this, "CacheManager");
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        if (instance != null) return instance;
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (instance != null) return instance;
            instance = new CacheManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTransient(URL url, Object value, int approxSize) {
        String key = Urls.getNoRefForm(url);
        LRUCache lRUCache = this.transientCache;
        synchronized (lRUCache) {
            this.transientCache.put(key, value, approxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransient(URL url) {
        String key = Urls.getNoRefForm(url);
        LRUCache lRUCache = this.transientCache;
        synchronized (lRUCache) {
            return this.transientCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransient(URL url) {
        String key = Urls.getNoRefForm(url);
        LRUCache lRUCache = this.transientCache;
        synchronized (lRUCache) {
            this.transientCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTransientCacheSize(int approxMaxSize) {
        LRUCache lRUCache = this.transientCache;
        synchronized (lRUCache) {
            this.transientCache.setApproxMaxSize(approxMaxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxTransientCacheSize() {
        LRUCache lRUCache = this.transientCache;
        synchronized (lRUCache) {
            return this.transientCache.getApproxMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheInfo getTransientCacheInfo() {
        List<LRUCache.EntryInfo> entryInfo;
        int numEntries;
        long approxSize;
        LRUCache lRUCache = this.transientCache;
        synchronized (lRUCache) {
            approxSize = this.transientCache.getApproxSize();
            numEntries = this.transientCache.getNumEntries();
            entryInfo = this.transientCache.getEntryInfoList();
        }
        return new CacheInfo(approxSize, numEntries, entryInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPersistent(URL url, byte[] rawContent, boolean isDecoration) throws IOException {
        File cacheFile = CacheManager.getCacheFile(url, isDecoration);
        Object object = CacheManager.getLock(cacheFile);
        synchronized (object) {
            File parent = cacheFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream fout = new FileOutputStream(cacheFile);
            try {
                fout.write(rawContent);
            }
            finally {
                fout.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPersistent(URL url, boolean isDecoration) throws IOException {
        File cacheFile = CacheManager.getCacheFile(url, isDecoration);
        Object object = CacheManager.getLock(cacheFile);
        synchronized (object) {
            cacheFile.setLastModified(System.currentTimeMillis());
            try {
                return IORoutines.load(cacheFile);
            }
            catch (FileNotFoundException fnf) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePersistent(URL url, boolean isDecoration) throws IOException {
        File cacheFile = CacheManager.getCacheFile(url, isDecoration);
        Object object = CacheManager.getLock(cacheFile);
        synchronized (object) {
            return cacheFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFile getJarFile(URL url) throws IOException {
        File cacheFile = CacheManager.getCacheFile(url, false);
        Object object = CacheManager.getLock(cacheFile);
        synchronized (object) {
            if (!cacheFile.exists()) {
                if (Urls.isLocalFile(url)) {
                    return new JarFile(url.getFile());
                }
                throw new FileNotFoundException("JAR file cannot be obtained for a URL that is not cached locally: " + url + ".");
            }
            cacheFile.setLastModified(System.currentTimeMillis());
            return new JarFile(cacheFile);
        }
    }

    private static File getCacheFile(URL url, boolean isDecoration) throws IOException {
        String simpleName;
        String urlFile = url.getFile();
        String urlText = Urls.getNoRefForm(url);
        int lastSlashIdx = urlFile.lastIndexOf(47);
        String string = simpleName = lastSlashIdx == -1 ? urlFile : urlFile.substring(lastSlashIdx + 1);
        if (simpleName.length() > 16) {
            simpleName = simpleName.substring(0, 16);
        }
        String normalizedName = Strings.getJavaIdentifier(simpleName);
        String hash = Strings.getMD5(urlText);
        String fileName = normalizedName + "_" + hash;
        if (isDecoration) {
            fileName = fileName + ".decor";
        }
        return StorageManager.getInstance().getContentCacheFile(url.getHost(), fileName);
    }

    private static Object getLock(File file) throws IOException {
        return ("cm:" + file.getCanonicalPath()).intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCacheFile(URL url, boolean isDecoration) throws IOException {
        File file = CacheManager.getCacheFile(url, isDecoration);
        Object object = CacheManager.getLock(file);
        synchronized (object) {
            if (file.exists()) {
                file.setLastModified(System.currentTimeMillis());
                return true;
            }
            return false;
        }
    }

    public void clearCache() throws Exception {
        File userHome = new File(System.getProperty("user.home"));
        File loboHome = new File(userHome, ".lobo");
        File cacheHome = new File(loboHome, "cache");
        File hostHome = new File(loboHome, "HostStore");
        this.deleteRecursive(cacheHome);
        this.deleteRecursive(hostHome);
    }

    private void deleteRecursive(File rootDir) {
        File[] c;
        for (File file : c = rootDir.listFiles()) {
            if (file.isDirectory()) {
                this.deleteRecursive(file);
                file.delete();
                continue;
            }
            file.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        CacheManager c = new CacheManager();
        c.clearCache();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            try {
                while (true) {
                    this.sweepCache();
                    Thread.sleep(300000L);
                }
            }
            catch (Throwable err) {
                logger.log(Level.SEVERE, "run()", err);
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private long getMaxCacheSize() {
        return 100000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweepCache() throws Exception {
        long oversize;
        CacheStoreInfo sinfo = this.getCacheStoreInfo();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("sweepCache(): Cache size is " + sinfo.getLength() + " with a max of " + this.getMaxCacheSize() + ". The number of cache files is " + sinfo.getFileInfos().length + ".");
        }
        if ((oversize = sinfo.getLength() - this.getMaxCacheSize()) > 0L) {
            Object[] finfos = sinfo.getFileInfos();
            Arrays.sort(finfos);
            long okToDeleteBeforeThis = System.currentTimeMillis() - 60000L;
            for (int i = 0; i < finfos.length; ++i) {
                try {
                    Thread.yield();
                    Object finfo = finfos[i];
                    Object object = CacheManager.getLock(((CacheFileInfo)finfo).getFile());
                    synchronized (object) {
                        long lastModified = ((CacheFileInfo)finfo).getLastModified();
                        if (lastModified < okToDeleteBeforeThis) {
                            Thread.sleep(1L);
                            long time1 = System.currentTimeMillis();
                            ((CacheFileInfo)finfo).delete();
                            long time2 = System.currentTimeMillis();
                            if (logger.isLoggable(Level.INFO)) {
                                logger.info("sweepCache(): Removed " + finfo + " in " + (time2 - time1) + " ms.");
                            }
                            if ((oversize -= ((CacheFileInfo)finfo).getInitialLength()) <= 0L) {
                                break;
                            }
                        }
                        continue;
                    }
                }
                catch (Throwable thrown) {
                    logger.log(Level.WARNING, "sweepCache()", thrown);
                }
            }
        }
    }

    private CacheStoreInfo getCacheStoreInfo() throws IOException {
        CacheStoreInfo csinfo = new CacheStoreInfo();
        File cacheRoot = StorageManager.getInstance().getCacheRoot();
        this.populateCacheStoreInfo(csinfo, cacheRoot);
        return csinfo;
    }

    private void populateCacheStoreInfo(CacheStoreInfo csinfo, File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            logger.severe("populateCacheStoreInfo(): Unexpected: '" + directory + "' is not a directory.");
            return;
        }
        if (files.length == 0) {
            directory.delete();
        }
        for (int i = 0; i < files.length; ++i) {
            Thread.yield();
            File file = files[i];
            if (file.isDirectory()) {
                this.populateCacheStoreInfo(csinfo, file);
                continue;
            }
            csinfo.addCacheFile(file);
        }
    }
}

