/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.store;

import java.io.IOException;
import java.io.OutputStream;
import org.lobobrowser.store.QuotaSource;

public class RestrictedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final QuotaSource quotaSource;

    public RestrictedOutputStream(OutputStream out, QuotaSource quotaSource) throws IOException {
        this.out = out;
        this.quotaSource = quotaSource;
    }

    @Override
    public void write(int b) throws IOException {
        this.quotaSource.addUsedBytes(1L);
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.quotaSource.addUsedBytes(len);
        this.out.write(b, off, len);
    }
}

