/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.LocalSecurityPolicy;
import org.lobobrowser.security.StoreHostPermission;
import org.lobobrowser.store.CacheManager;
import org.lobobrowser.store.ClassLoaderObjectInputStream;
import org.lobobrowser.store.RestrictedStore;

public class StorageManager
implements Runnable {
    private static final Logger logger = Logger.getLogger(StorageManager.class.getName());
    private static final long HOST_STORE_QUOTA = 204800L;
    private static final String HOST_STORE_DIR = "HostStore";
    private static final String CACHE_DIR = "cache";
    private static final String CONTENT_DIR = "content";
    private static final String SETTINGS_DIR = "settings";
    private static final StorageManager instance = new StorageManager();
    private final File storeDirectory;
    private boolean threadStarted = false;
    private static final String NO_HOST = "$NO_HOST$";
    private final Map<String, RestrictedStore> restrictedStoreCache = new HashMap<String, RestrictedStore>();
    private static final int MANAGED_STORE_UPDATE_DELAY = 300000;

    public static StorageManager getInstance() throws IOException {
        return instance;
    }

    private StorageManager() {
        this.storeDirectory = LocalSecurityPolicy.STORE_DIRECTORY;
        if (!this.storeDirectory.exists()) {
            this.storeDirectory.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureThreadStarted() {
        if (!this.threadStarted) {
            StorageManager storageManager = this;
            synchronized (storageManager) {
                if (!this.threadStarted) {
                    Thread t = new Thread((Runnable)this, "StorageManager");
                    t.setDaemon(true);
                    t.setPriority(1);
                    t.start();
                    this.threadStarted = true;
                }
            }
        }
    }

    public File getAppHome() {
        return this.storeDirectory;
    }

    public File getCacheHostDirectory(String hostName) throws IOException {
        CacheManager.getInstance();
        File cacheDir = this.getCacheRoot();
        if (hostName == null || "".equals(hostName)) {
            hostName = NO_HOST;
        }
        return new File(cacheDir, StorageManager.normalizedFileName(hostName));
    }

    public File getContentCacheFile(String hostName, String fileName) throws IOException {
        File domainDir = this.getCacheHostDirectory(hostName);
        File xamjDir = new File(domainDir, CONTENT_DIR);
        return new File(xamjDir, fileName);
    }

    public File getCacheRoot() {
        return new File(this.storeDirectory, CACHE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestrictedStore getRestrictedStore(String hostName, final boolean createIfNotExists) throws IOException {
        RestrictedStore store;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(StoreHostPermission.forHost(hostName));
        }
        if (hostName == null || "".equals(hostName)) {
            hostName = NO_HOST;
        }
        final String normHost = hostName;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            store = this.restrictedStoreCache.get(normHost);
            if (store == null && (store = AccessController.doPrivileged(new PrivilegedAction<RestrictedStore>(){

                @Override
                public RestrictedStore run() {
                    File hostStoreDir = new File(StorageManager.this.storeDirectory, StorageManager.HOST_STORE_DIR);
                    File domainDir = new File(hostStoreDir, StorageManager.normalizedFileName(normHost));
                    if (!createIfNotExists && !domainDir.exists()) {
                        return null;
                    }
                    try {
                        return new RestrictedStore(domainDir, 204800L);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException(ioe);
                    }
                }
            })) != null) {
                this.restrictedStoreCache.put(normHost, store);
            }
        }
        if (store != null) {
            this.ensureThreadStarted();
        }
        return store;
    }

    public File getSettingsDirectory() {
        return new File(this.storeDirectory, SETTINGS_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings(String name, Serializable data) throws IOException {
        File dir = this.getSettingsDirectory();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, name);
        FileOutputStream out = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(data);
            oos.flush();
        }
        finally {
            oos.close();
            bos.close();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable retrieveSettings(String name, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        File dir = this.getSettingsDirectory();
        if (!dir.exists()) {
            return null;
        }
        File file = new File(dir, name);
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        BufferedInputStream bin = new BufferedInputStream(in);
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(bin, classLoader);
        try {
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (InvalidClassException ice) {
            logger.severe(ice.getMessage());
            Serializable serializable = null;
            return serializable;
        }
        finally {
            ois.close();
            bin.close();
            ((InputStream)in).close();
        }
    }

    static String normalizedFileName(String hostName) {
        return hostName;
    }

    static String getHostName(String fileName) {
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                block8: while (true) {
                    RestrictedStore[] stores;
                    Thread.sleep(300000L);
                    StorageManager storageManager = this;
                    synchronized (storageManager) {
                        stores = this.restrictedStoreCache.values().toArray(new RestrictedStore[0]);
                    }
                    int i = 0;
                    while (true) {
                        if (i >= stores.length) continue block8;
                        Thread.yield();
                        stores[i].updateSizeFile();
                        ++i;
                    }
                    break;
                }
            }
            catch (Throwable err) {
                logger.log(Level.SEVERE, "run()", err);
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

