/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public abstract class AbstractBean {
    private transient PropertyChangeSupport pcs;
    private transient VetoableChangeSupport vcs;

    protected AbstractBean() {
        this.pcs = new PropertyChangeSupport(this);
        this.vcs = new VetoableChangeSupport(this);
    }

    protected AbstractBean(PropertyChangeSupport pcs, VetoableChangeSupport vcs) {
        if (pcs == null) {
            throw new NullPointerException("PropertyChangeSupport must not be null");
        }
        if (vcs == null) {
            throw new NullPointerException("VetoableChangeSupport must not be null");
        }
        this.pcs = pcs;
        this.vcs = vcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    protected boolean hasPropertyChangeListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    protected boolean hasVetoableChangeListeners(String propertyName) {
        return this.vcs.hasListeners(propertyName);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs.removeVetoableChangeListener(listener);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vcs.getVetoableChangeListeners();
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcs.addVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcs.removeVetoableChangeListener(propertyName, listener);
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        return this.vcs.getVetoableChangeListeners(propertyName);
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vcs.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.vcs.fireVetoableChange(evt);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractBean result = (AbstractBean)super.clone();
        result.pcs = new PropertyChangeSupport(result);
        result.vcs = new VetoableChangeSupport(result);
        return result;
    }
}

