/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.OrderedValue;
import org.lobobrowser.util.RemovalDispatch;
import org.lobobrowser.util.RemovalEvent;
import org.lobobrowser.util.RemovalListener;

public class LRUCache
implements Serializable {
    private static final long serialVersionUID = 940427225784212823L;
    private int approxMaxSize;
    private final Map<Object, OrderedValue> cacheMap = new HashMap<Object, OrderedValue>();
    private volatile transient EventDispatch2 removalEvent;
    private final TreeSet<OrderedValue> timedSet = new TreeSet();
    private int currentSize = 0;

    public LRUCache(int approxMaxSize) {
        this.approxMaxSize = approxMaxSize;
        this.removalEvent = new RemovalDispatch();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.removalEvent = new RemovalDispatch();
    }

    public int getApproxMaxSize() {
        return this.approxMaxSize;
    }

    public void setApproxMaxSize(int approxMaxSize) {
        this.approxMaxSize = approxMaxSize;
    }

    public void put(Object key, Object value, int approxSize) {
        if (approxSize > this.approxMaxSize) {
            return;
        }
        OrderedValue ordVal = this.cacheMap.get(key);
        if (ordVal != null) {
            if (ordVal.getValue() != value) {
                this.removalEvent.fireEvent(new RemovalEvent(this, ordVal.getValue()));
            }
            this.currentSize += approxSize - ordVal.getApproximateSize();
            this.timedSet.remove(ordVal);
            ordVal.setApproximateSize(approxSize);
            ordVal.setValue(value);
            ordVal.touch();
            this.timedSet.add(ordVal);
        } else {
            ordVal = new OrderedValue(key, value, approxSize);
            this.cacheMap.put(key, ordVal);
            this.timedSet.add(ordVal);
            this.currentSize += approxSize;
        }
        while (this.currentSize > this.approxMaxSize) {
            this.removeLRU();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeLRU() {
        if (this.timedSet == null) return;
        OrderedValue ordVal = this.timedSet.first();
        if (ordVal == null) throw new IllegalStateException("Cannot remove LRU since the cache is empty.");
        this.removalEvent.fireEvent(new RemovalEvent(this, ordVal.getValue()));
        if (!this.timedSet.remove(ordVal)) throw new IllegalStateException("Could not remove existing tree node.");
        this.cacheMap.remove(ordVal.getKey());
        this.currentSize -= ordVal.getApproximateSize();
    }

    public Object get(Object key) {
        OrderedValue ordVal = this.cacheMap.get(key);
        if (ordVal != null) {
            this.timedSet.remove(ordVal);
            ordVal.touch();
            this.timedSet.add(ordVal);
            return ordVal.getValue();
        }
        return null;
    }

    public Object remove(Object key) {
        OrderedValue ordVal = this.cacheMap.get(key);
        if (ordVal != null) {
            this.removalEvent.fireEvent(new RemovalEvent(this, ordVal.getValue()));
            this.currentSize -= ordVal.getApproximateSize();
            this.timedSet.remove(ordVal);
            return ordVal.getValue();
        }
        return null;
    }

    public void addRemovalListener(RemovalListener listener) {
        this.removalEvent.addListener(listener);
    }

    public void removeRemovalListener(RemovalListener listener) {
        this.removalEvent.removeListener(listener);
    }

    public int getApproxSize() {
        return this.currentSize;
    }

    public int getNumEntries() {
        return this.cacheMap.size();
    }

    public List<EntryInfo> getEntryInfoList() {
        ArrayList<EntryInfo> list = new ArrayList<EntryInfo>();
        for (OrderedValue ov : this.cacheMap.values()) {
            Object value = ov.getValue();
            Class<?> vc = value == null ? null : value.getClass();
            list.add(new EntryInfo(vc, ov.getApproximateSize()));
        }
        return list;
    }

    public static class EntryInfo {
        public final Class<?> valueClass;
        public final int approximateSize;

        public EntryInfo(Class<?> valueClass, int approximateSize) {
            this.valueClass = valueClass;
            this.approximateSize = approximateSize;
        }

        public String toString() {
            Class<?> vc = this.valueClass;
            String vcName = vc == null ? "<none>" : vc.getName();
            return "[class=" + vcName + ",approx-size=" + this.approximateSize + "]";
        }
    }
}

