/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodResultTypeSerializer;
import com.intellij.javaee.process.common.WrappedException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodResultSerializer {
    private final List<MethodResultTypeSerializer<?>> myTypeSerializers = new ArrayList();

    public MethodResultSerializer() {
        this.addType(new MethodResultTypeSerializer<String>(String.class){

            @Override
            protected String doSerializeResult(String methodResult) {
                return methodResult;
            }
        });
        this.addType(new MethodResultTypeSerializer<Void>(Void.class){

            @Override
            protected String doSerializeResult(Void methodResult) {
                return "";
            }
        });
        this.addType(new MethodResultTypeSerializer<Boolean>(Boolean.class){

            @Override
            protected String doSerializeResult(Boolean methodResult) {
                return String.valueOf(methodResult);
            }
        });
        this.addType(new MethodResultTypeSerializer<Boolean>(Boolean.TYPE){

            @Override
            protected String doSerializeResult(Boolean methodResult) {
                return String.valueOf(methodResult);
            }
        });
        this.addType(new MethodResultTypeSerializer<Integer>(Integer.class){

            @Override
            protected String doSerializeResult(Integer methodResult) {
                return String.valueOf(methodResult);
            }
        });
        this.addType(new MethodResultTypeSerializer<Integer>(Integer.TYPE){

            @Override
            protected String doSerializeResult(Integer methodResult) {
                return String.valueOf(methodResult);
            }
        });
        this.addType(new MethodResultTypeSerializer<File>(File.class){

            @Override
            protected String doSerializeResult(File methodResult) {
                return methodResult.getAbsolutePath();
            }
        });
        this.addType(new MethodResultTypeSerializer<WrappedException>(WrappedException.class){

            @Override
            protected String doSerializeResult(WrappedException methodResult) {
                return methodResult.serialize();
            }
        });
    }

    public void addType(MethodResultTypeSerializer<?> typeSerializer) {
        this.myTypeSerializers.add(typeSerializer);
    }

    public String serialize(Object methodResult) throws JavaeeProcessUtilException {
        if (methodResult == null) {
            return null;
        }
        String[] resultRef = new String[1];
        for (MethodResultTypeSerializer<?> typeSerializer : this.myTypeSerializers) {
            if (!typeSerializer.serializeResult(methodResult, resultRef)) continue;
            return resultRef[0];
        }
        throw new JavaeeProcessUtilException("Unknown result type: " + methodResult.getClass() + " (" + methodResult + ")");
    }

    public String[] serializeArgs(Object[] args) throws JavaeeProcessUtilException {
        if (args == null) {
            return null;
        }
        int argCount = args.length;
        String[] result = new String[argCount];
        for (int iArg = 0; iArg < argCount; ++iArg) {
            result[iArg] = this.serialize(args[iArg]);
        }
        return result;
    }
}

