/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.impl.QlReferenceImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            QlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            QlCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!(parameters.getPosition().getContainingFile() instanceof QlFile)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (position instanceof PsiComment) {
            return;
        }
        PsiElement prevSibling = position.getParent().getPrevSibling();
        if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == QlTypes.QL_DOT) {
            return;
        }
        if (parameters.getCompletionType() == CompletionType.BASIC) {
            Collection<String> suggestedKeywords = QlCompletionContributor.suggestKeywords(parameters.getPosition());
            for (String keyword : suggestedKeywords) {
                result.addElement(QlReferenceImpl.createKeywordLookupItem(keyword));
            }
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            QlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        PsiFile file = context.getFile();
        if (!(file instanceof QlFile)) {
            return;
        }
        int offset = context.getStartOffset();
        PsiElement element = file.findElementAt(offset);
        if (element != null) {
            ASTNode node = element.getNode();
            IElementType type = node != null ? node.getElementType() : null;
            boolean doNotPatch = type != null && QlLexer.getKeywordMap(file.getLanguage()).containsKey(type.toString()) && !QlLexer.isOptionalKeyword(type.toString());
            boolean bl = doNotPatch = doNotPatch || (element.getTextRange().getStartOffset() != offset || element.getParent() instanceof QlIdentifier) && file.findReferenceAt(offset) != null;
            if (doNotPatch) {
                context.setDummyIdentifier("");
            }
        }
    }

    public static Collection<String> suggestKeywords(@NotNull PsiElement position) {
        if (position == null) {
            QlCompletionContributor.$$$reportNull$$$0(3);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, QlStringLiteral.class) != null) {
            return Collections.emptyList();
        }
        QlFile sqlFile = (QlFile)position.getContainingFile();
        Language language = sqlFile.getLanguage();
        String fragment = InjectedLanguageUtil.getUnescapedText((PsiFile)sqlFile, null, (PsiElement)position);
        boolean empty = StringUtil.isEmptyOrSpaces((String)fragment);
        String text = empty ? "IntellijIdeaRulezzz " : fragment;
        int completionOffset = empty ? 0 : fragment.length();
        PsiFile file = PsiFileFactory.getInstance((Project)sqlFile.getProject()).createFileFromText("a.ql", language, (CharSequence)text, true, false);
        GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){

            @Nullable
            public String convertItem(Object o) {
                if (o instanceof IElementType[]) {
                    return super.convertItem(o);
                }
                String text = o != QlTypes.QL_STRING && o != QlTypes.QL_NUMBER && o != QlLexer.QL_IDENTIFIER && o != null ? o.toString() : null;
                return text != null && text.length() > 0 && StringUtil.isJavaIdentifierStart((char)text.charAt(0)) ? text : null;
            }
        };
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
        return state.items;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/ql/completion/QlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

