/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdateSessionAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;

abstract class AbstractUpdateEnvironment
implements UpdateEnvironment {
    protected final Project myProject;
    protected final PerforceRunner myRunner;

    public AbstractUpdateEnvironment(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(project);
    }

    protected static void processOutput(String output, UpdatedFiles updatedFiles, Map<String, String> patternToGroupId, PerforceClient client) throws VcsException {
        String[] lines;
        for (String line : lines = LineTokenizer.tokenize((CharSequence)output, (boolean)false)) {
            AbstractUpdateEnvironment.fillUpdateInformationFromTheLine(line, updatedFiles, patternToGroupId, client);
        }
    }

    private static void fillUpdateInformationFromTheLine(String line, UpdatedFiles updatedFiles, Map<String, String> patternToGroupId, PerforceClient client) throws VcsException {
        for (String pattern : patternToGroupId.keySet()) {
            if (!AbstractUpdateEnvironment.processLine(line, updatedFiles, pattern, patternToGroupId.get(pattern), client)) continue;
            return;
        }
    }

    private static boolean processLine(String line, UpdatedFiles updatedFiles, String message, String fileGroupId, PerforceClient client) throws VcsException {
        int messageStart = line.indexOf(message);
        if (messageStart < 0) {
            return false;
        }
        String depotFilePath = line.substring(0, messageStart).trim();
        File fileByDepotName = PerforceManager.getFileByDepotName(depotFilePath, client);
        String filePath = fileByDepotName != null ? fileByDepotName.getPath() : depotFilePath;
        int revNumPos = depotFilePath.indexOf(35);
        PerforceOnlyRevisionNumber revision = revNumPos > 0 ? new PerforceOnlyRevisionNumber(Long.parseLong(depotFilePath.substring(revNumPos + 1))) : null;
        updatedFiles.getGroupById(fileGroupId).add(filePath, PerforceVcs.getKey(), (VcsRevisionNumber)revision);
        return true;
    }

    protected PerforceSettings getSettings() {
        return PerforceSettings.getSettings(this.myProject);
    }

    private void resolveAutomatically(P4File contentRoot) throws VcsException {
        this.myRunner.resolveAutomatically(contentRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> context) throws ProcessCanceledException {
        block21: {
            if (contentRoots == null) {
                AbstractUpdateEnvironment.$$$reportNull$$$0(0);
            }
            if (context == null) {
                AbstractUpdateEnvironment.$$$reportNull$$$0(1);
            }
            settings = this.getSettings();
            if (!settings.ENABLED) {
                v0 = new UpdateSessionAdapter(Collections.singletonList(new VcsException("Perforce is offline")), false);
                if (v0 == null) {
                    AbstractUpdateEnvironment.$$$reportNull$$$0(2);
                }
                return v0;
            }
            vcsExceptions = new ArrayList<Throwable>();
            try {
                map = FileGrouper.distributePathsByConnection(Arrays.asList(contentRoots), this.myProject);
                perforceManager = PerforceManager.getInstance(this.myProject);
                for (P4Connection connection : map.keySet()) {
                    if (!this.isRevertUnchanged(settings)) ** GOTO lbl35
                    paths = ContainerUtil.map2List((Collection)map.get((Object)connection), (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateDirectories$0(com.intellij.openapi.vcs.FilePath ), (Lcom/intellij/openapi/vcs/FilePath;)Ljava/lang/String;)());
                    try {
                        this.myRunner.revertUnchanged(connection, paths);
                        ** GOTO lbl35
                    }
                    catch (VcsConnectionProblem e) {
                        vcsExceptions.add(e);
                        ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updateDirectories$1(com.intellij.openapi.vcs.VcsConnectionProblem ), ()V)((VcsConnectionProblem)e));
                        var13_17 = new UpdateSessionAdapter(vcsExceptions, true);
                        PerforceSettings.getSettings((Project)this.myProject).SYNC_FORCE = false;
                        v1 = var13_17;
                        if (v1 == null) {
                            AbstractUpdateEnvironment.$$$reportNull$$$0(3);
                        }
                        return v1;
                    }
                    catch (VcsException e) {
                        vcsExceptions.add(e);
lbl35:
                        // 3 sources

                        try {
                            client = perforceManager.getClient(connection);
                            for (FilePath path : map.get((Object)connection)) {
                                p4Dir = P4File.create(path);
                                execResult = this.performUpdate(p4Dir, settings);
                                AbstractUpdateEnvironment.processOutput(execResult.getStdout(), updatedFiles, this.getPatternToGroupId(), client);
                                updateExceptions = PerforceRunner.checkErrors(execResult, settings, connection);
                                if (updateExceptions.length > 0) {
                                    Collections.addAll(vcsExceptions, updateExceptions);
                                    continue;
                                }
                                if (!this.isTryToResolveAutomatically(settings)) continue;
                                this.resolveAutomatically(p4Dir);
                            }
                        }
                        catch (VcsConnectionProblem e) {
                            vcsExceptions.add(e);
                            ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updateDirectories$2(com.intellij.openapi.vcs.VcsConnectionProblem ), ()V)((VcsConnectionProblem)e));
                            var12_14 = new UpdateSessionAdapter(vcsExceptions, true);
                            PerforceSettings.getSettings((Project)this.myProject).SYNC_FORCE = false;
                            v2 = var12_14;
                            if (v2 == null) {
                                AbstractUpdateEnvironment.$$$reportNull$$$0(4);
                            }
                            return v2;
                        }
                        catch (VcsException e) {
                            vcsExceptions.add(e);
                        }
                    }
                }
                this.handleResolveConflicts(map);
                break block21;
                {
                    catch (Throwable var17_21) {
                        throw var17_21;
                    }
                }
            }
            finally {
                PerforceSettings.getSettings((Project)this.myProject).SYNC_FORCE = false;
            }
        }
        v3 = new UpdateSessionAdapter(vcsExceptions, false);
        if (v3 == null) {
            AbstractUpdateEnvironment.$$$reportNull$$$0(5);
        }
        return v3;
    }

    private void handleResolveConflicts(MultiMap<P4Connection, FilePath> map) {
        try {
            LinkedList<VirtualFile> filesToResolve = new LinkedList<VirtualFile>();
            for (P4Connection connection : map.keySet()) {
                for (FilePath root : map.get((Object)connection)) {
                    VirtualFile file = root.getVirtualFile();
                    if (file == null) continue;
                    filesToResolve.addAll(this.filterByServerVersion(this.myRunner.getResolvedWithConflicts(connection, file)));
                }
            }
            if (!filesToResolve.isEmpty()) {
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> new PerforceMergeProvider(this.myProject).showMergeDialog(filesToResolve));
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
    }

    private List<VirtualFile> filterByServerVersion(Collection<VirtualFile> allFilesToResolve) throws VcsException {
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(this.myProject);
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : allFilesToResolve) {
            if (PerforceSettings.getSettings(this.myProject).getServerVersion(connectionManager.getConnectionForFile(virtualFile)) < 2004L) continue;
            result.add(virtualFile);
        }
        return result;
    }

    protected abstract boolean isTryToResolveAutomatically(PerforceSettings var1);

    protected abstract Map<String, String> getPatternToGroupId();

    protected abstract boolean isRevertUnchanged(PerforceSettings var1);

    protected abstract ExecResult performUpdate(P4File var1, PerforceSettings var2) throws VcsException;

    private static /* synthetic */ void lambda$updateDirectories$2(VcsConnectionProblem e) {
        e.attemptQuickFix(true);
    }

    private static /* synthetic */ void lambda$updateDirectories$1(VcsConnectionProblem e) {
        e.attemptQuickFix(true);
    }

    private static /* synthetic */ String lambda$updateDirectories$0(FilePath path) {
        return P4File.create(path).getRecursivePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/AbstractUpdateEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/AbstractUpdateEnvironment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

