/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.NumberNameModifier;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;

public class PerforceNumberNameMap
implements NumberNameModifier {
    private final MultiMap<String, Long> myNameToNumber = MultiMap.createSet();
    private final Map<Long, String> myNumberToName = ContainerUtil.newHashMap();

    void cleanup() {
        Set names = this.myNameToNumber.keySet();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!this.myNameToNumber.get((Object)name).isEmpty()) continue;
            iterator.remove();
        }
    }

    public String getName(@NotNull Long number) {
        if (number == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(0);
        }
        return this.myNumberToName.get(number);
    }

    @Override
    public void put(@NotNull String name, @NotNull Long nativeNumber) {
        if (name == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(1);
        }
        if (nativeNumber == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(2);
        }
        this.myNumberToName.put(nativeNumber, name);
        this.myNameToNumber.putValue((Object)name, (Object)nativeNumber);
    }

    public Collection<Long> getNumbers(@NotNull String name) {
        if (name == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(3);
        }
        return new ArrayList<Long>(this.myNameToNumber.get((Object)name));
    }

    @Override
    public void remove(@NotNull String name, @NotNull Long nativeNumber) {
        if (name == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(4);
        }
        if (nativeNumber == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(5);
        }
        this.myNumberToName.remove(nativeNumber);
        this.myNameToNumber.get((Object)name).remove(nativeNumber);
    }

    Set<String> removeEmpty(Collection<PerforceChangeList> existing) {
        HashSet<Long> orphanNumbers = new HashSet<Long>(this.myNumberToName.keySet());
        for (PerforceChangeList pair : existing) {
            orphanNumbers.remove(pair.getNumber());
        }
        HashSet<String> result = new HashSet<String>();
        HashSet onStartNames = new HashSet(this.myNameToNumber.keySet());
        for (Long number : orphanNumbers) {
            this.myNumberToName.remove(number);
            for (String key : onStartNames) {
                if (!this.myNameToNumber.containsKey((Object)key)) continue;
                this.myNameToNumber.remove((Object)key, (Object)number);
            }
        }
        for (String name : onStartNames) {
            Collection clNumbers = this.myNameToNumber.get((Object)name);
            if (!clNumbers.isEmpty()) continue;
            result.add(name);
            this.myNameToNumber.remove((Object)name);
        }
        return result;
    }

    @Override
    public void removeListIfEmpty(@NotNull String name) {
        Collection numbers;
        if (name == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(6);
        }
        if ((numbers = this.myNameToNumber.get((Object)name)).isEmpty()) {
            this.myNameToNumber.remove((Object)name);
        }
    }

    @Override
    public boolean haveSingleAssociation(@NotNull String name) {
        if (name == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(7);
        }
        return this.myNameToNumber.get((Object)name).size() == 1;
    }

    @Override
    public void rename(@NotNull String from, @NotNull String to) {
        Collection associated;
        if (from == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(8);
        }
        if (to == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(9);
        }
        if ((associated = this.myNameToNumber.remove((Object)from)) == null) {
            return;
        }
        this.myNameToNumber.put((Object)to, associated);
        for (Long number : associated) {
            this.myNumberToName.put(number, to);
        }
    }

    @Override
    public void add(@NotNull String name) {
        if (name == null) {
            PerforceNumberNameMap.$$$reportNull$$$0(10);
        }
        if (!this.myNameToNumber.containsKey((Object)name)) {
            this.myNameToNumber.put((Object)name, new HashSet());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeNumber";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceNumberNameMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNumbers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListIfEmpty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "haveSingleAssociation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

