/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4CopyOperation;
import org.jetbrains.idea.perforce.operations.P4DeleteOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.P4MoveToChangeListOperation;
import org.jetbrains.idea.perforce.operations.P4RevertOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@State(name="VcsOperationLog", storages={@Storage(value="$WORKSPACE_FILE$")})
public class VcsOperationLog
implements PersistentStateComponent<OperationList> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.operations.VcsOperationLog");
    private final Object lock = new Object();
    private final Project myProject;
    private OperationList myOperations = new OperationList();

    public VcsOperationLog(Project project) {
        this.myProject = project;
    }

    public static VcsOperationLog getInstance(Project project) {
        return (VcsOperationLog)PeriodicalTasksCloser.getInstance().safeGetService(project, VcsOperationLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationList getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(OperationList state) {
        Object object = this.lock;
        synchronized (object) {
            this.myOperations = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLog(VcsOperation vcsOperation) {
        Object object = this.lock;
        synchronized (object) {
            for (VcsOperation oldOp : this.myOperations.myOperationsByOutputPath.get((Object)vcsOperation.getInputPath())) {
                VcsOperation mergedOp = vcsOperation.checkMerge(oldOp);
                if (mergedOp == oldOp) continue;
                this.myOperations.removeOperation(oldOp);
                if (mergedOp != null) {
                    this.myOperations.addOperation(mergedOp);
                }
                return;
            }
            LOG.debug("Add to log " + vcsOperation);
            vcsOperation.prepareOffline(this.myProject);
            this.myOperations.addOperation(vcsOperation);
        }
    }

    public boolean runOperations(List<VcsOperation> operations, String title, PerformInBackgroundOption option, List<VcsException> exceptions) {
        Runnable runnable = this.enqueueOperations(operations, title, option, exceptions);
        if (runnable == null) {
            return false;
        }
        int startSize = exceptions.size();
        runnable.run();
        return startSize == exceptions.size();
    }

    public void queueOperations(List<? extends VcsOperation> operations, String title, PerformInBackgroundOption option) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Runnable runnable = this.enqueueOperations(operations, title, option, exceptions);
        if (runnable == null) {
            return;
        }
        PerforceVcs.getInstance(this.myProject).runBackgroundTask(title, option, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Runnable enqueueOperations(List<? extends VcsOperation> operations, String title, PerformInBackgroundOption option, List<VcsException> exceptions) {
        Object object = this.lock;
        synchronized (object) {
            for (VcsOperation vcsOperation : operations) {
                this.addToLog(vcsOperation);
            }
        }
        if (!PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            return null;
        }
        return () -> {
            HashSet<P4Connection> authorized = new HashSet<P4Connection>();
            while (true) {
                try {
                    while (new MergedOperationExecutor(this.takeMergeableOperations(), title, option, authorized).executeOperations()) {
                    }
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    continue;
                }
                break;
            }
            if (!exceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, title);
            }
        };
    }

    public void replayLog() {
        String title = PerforceBundle.message((String)"replaying.offline.operations", (Object[])new Object[0]);
        this.queueOperations(Collections.emptyList(), title, PerformInBackgroundOption.DEAF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VcsOperation> takeMergeableOperations() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.myOperations.myOperationsByOutputPath.isEmpty()) {
                Collection allOperations = this.myOperations.myOperationsByOutputPath.values();
                VcsOperation firstOp = (VcsOperation)allOperations.iterator().next();
                List mergeable = ContainerUtil.filter((Collection)allOperations, op -> op.getClass() == firstOp.getClass());
                mergeable.forEach(x$0 -> this.myOperations.removeOperation(x$0));
                return mergeable;
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsOperation> getPendingOperations() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOperations.getOperations();
        }
    }

    public Map<String, String> getReopenedPaths() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (VcsOperation op : this.getPendingOperations()) {
            op.fillReopenedPaths(result);
        }
        return result;
    }

    private class MergedOperationExecutor {
        private final LinkedHashSet<VcsOperation> myRemaining;
        private final String myTitle;
        private final PerformInBackgroundOption myOption;
        private final Set<P4Connection> myAuthorized;
        private final ProcessingContext myContext = new ProcessingContext();

        public MergedOperationExecutor(List<VcsOperation> operations, String title, PerformInBackgroundOption option, Set<P4Connection> authorized) {
            this.myRemaining = new LinkedHashSet<VcsOperation>(operations);
            this.myTitle = title;
            this.myOption = option;
            this.myAuthorized = authorized;
        }

        @Nullable
        private java.util.LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> mergeOperations() throws VcsException {
            java.util.LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result = new java.util.LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>>();
            MultiMap byConnection = new MultiMap();
            for (VcsOperation operation : this.myRemaining) {
                Set<P4Connection> touchedConnections = this.ensureAuthorized(operation);
                if (touchedConnections == null) {
                    return null;
                }
                if (touchedConnections.size() == 1) {
                    byConnection.putValue((Object)touchedConnections.iterator().next(), (Object)operation);
                    continue;
                }
                this.handleNonMergeableOperation(result, operation);
            }
            if (this.myRemaining.iterator().next() instanceof P4RevertOperation) {
                for (P4Connection connection : byConnection.keySet()) {
                    this.mergeRevert(result, connection, byConnection.get((Object)connection));
                }
            } else {
                for (VcsOperation operation : byConnection.values()) {
                    this.handleNonMergeableOperation(result, operation);
                }
            }
            return result;
        }

        private void mergeRevert(java.util.LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result, @NotNull P4Connection connection, Collection<VcsOperation> operations) {
            if (connection == null) {
                MergedOperationExecutor.$$$reportNull$$$0(0);
            }
            if (operations.size() == 1) {
                this.handleNonMergeableOperation(result, operations.iterator().next());
                return;
            }
            result.put((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> {
                if (connection == null) {
                    MergedOperationExecutor.$$$reportNull$$$0(1);
                }
                ArrayList<String> toRevert = new ArrayList<String>();
                ArrayList<File> toDelete = new ArrayList<File>();
                for (VcsOperation operation : operations) {
                    ((P4RevertOperation)operation).prepareRevert(toRevert, toDelete);
                }
                PerforceRunner.getInstance(VcsOperationLog.this.myProject).revertAll(toRevert, connection);
                P4RevertOperation.refreshAfterRevert(toRevert, toDelete, VcsOperationLog.this.myProject);
            }), operations);
        }

        private void handleNonMergeableOperation(java.util.LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result, VcsOperation operation) {
            result.put((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> operation.execute(VcsOperationLog.this.myProject, this.myContext)), Collections.singletonList(operation));
        }

        @Nullable
        private Set<P4Connection> ensureAuthorized(VcsOperation operation) throws VcsException {
            HashSet<P4Connection> touchedConnections = new HashSet<P4Connection>();
            for (String path : operation.getAffectedPaths()) {
                P4Connection connection = PerforceConnectionManager.getInstance(VcsOperationLog.this.myProject).getConnectionForFile(new File(path));
                if (connection == null) {
                    this.pushBackOperations();
                    throw new VcsException("Can not execute '" + this.myTitle + "'. Invalid connection settings.");
                }
                touchedConnections.add(connection);
                if (!this.myAuthorized.add(connection)) continue;
                try {
                    PerforceLoginManager.getInstance(VcsOperationLog.this.myProject).check(connection, true);
                }
                catch (VcsConnectionProblem e) {
                    this.pushBackOperations();
                    this.fixLater(e);
                    return null;
                }
            }
            return touchedConnections;
        }

        private void fixLater(VcsConnectionProblem e) {
            LOG.info((Throwable)e);
            boolean inTests = ApplicationManager.getApplication().isUnitTestMode();
            Runnable runnable = () -> {
                if (e.attemptQuickFix(!inTests) && PerforceSettings.getSettings((Project)((VcsOperationLog)VcsOperationLog.this).myProject).ENABLED) {
                    VcsOperationLog.this.queueOperations(Collections.emptyList(), this.myTitle, this.myOption);
                } else {
                    PerforceSettings.getSettings(VcsOperationLog.this.myProject).disable(false);
                }
            };
            if (!inTests) {
                ApplicationManager.getApplication().invokeLater(runnable);
            } else {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pushBackOperations() {
            Object object = VcsOperationLog.this.lock;
            synchronized (object) {
                VcsOperationLog.this.myOperations.setOperations(ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{this.myRemaining, VcsOperationLog.this.myOperations.getOperations()})));
            }
        }

        private boolean executeOperations() throws VcsException {
            if (this.myRemaining.isEmpty()) {
                return false;
            }
            java.util.LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> map = this.mergeOperations();
            if (map == null) {
                return false;
            }
            for (ThrowableRunnable<VcsException> composite : map.keySet()) {
                try {
                    composite.run();
                }
                catch (VcsConnectionProblem e) {
                    this.pushBackOperations();
                    this.fixLater(e);
                    return false;
                }
                this.myRemaining.removeAll(map.get(composite));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "connection";
            objectArray2[1] = "org/jetbrains/idea/perforce/operations/VcsOperationLog$MergedOperationExecutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRevert";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$mergeRevert$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OperationList {
        private final MultiMap<String, VcsOperation> myOperationsByOutputPath = new MultiMap<String, VcsOperation>(){

            @NotNull
            protected Map<String, Collection<VcsOperation>> createMap() {
                LinkedHashMap linkedHashMap = new LinkedHashMap((EqualityPolicy)new EqualityPolicy<String>(){

                    public int getHashCode(String value) {
                        return FileUtil.pathHashCode((String)value);
                    }

                    public boolean isEqual(String val1, String val2) {
                        return FileUtil.pathsEqual((String)val1, (String)val2);
                    }
                });
                if (linkedHashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return linkedHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/operations/VcsOperationLog$OperationList$1", "createMap"));
            }
        };

        @AbstractCollection(elementTypes={P4AddOperation.class, P4CopyOperation.class, P4DeleteOperation.class, P4MoveRenameOperation.class, P4EditOperation.class, P4RevertOperation.class, P4MoveToChangeListOperation.class})
        public List<VcsOperation> getOperations() {
            return new ArrayList<VcsOperation>(this.myOperationsByOutputPath.values());
        }

        @AbstractCollection(elementTypes={P4AddOperation.class, P4CopyOperation.class, P4DeleteOperation.class, P4MoveRenameOperation.class, P4EditOperation.class, P4RevertOperation.class, P4MoveToChangeListOperation.class})
        public void setOperations(@NotNull List<VcsOperation> operations) {
            if (operations == null) {
                OperationList.$$$reportNull$$$0(0);
            }
            this.myOperationsByOutputPath.clear();
            for (VcsOperation operation : operations) {
                this.addOperation(operation);
            }
        }

        private void addOperation(@NotNull VcsOperation operation) {
            if (operation == null) {
                OperationList.$$$reportNull$$$0(1);
            }
            this.myOperationsByOutputPath.putValue((Object)operation.getOutputPath(), (Object)operation);
        }

        private void removeOperation(@NotNull VcsOperation operation) {
            if (operation == null) {
                OperationList.$$$reportNull$$$0(2);
            }
            this.myOperationsByOutputPath.remove((Object)operation.getOutputPath(), (Object)operation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operations";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/perforce/operations/VcsOperationLog$OperationList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOperations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOperation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeOperation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

