/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.config.SpringBootConfigFileAnnotatorBase;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootApplicationYamlAnnotator
extends SpringBootConfigFileAnnotatorBase {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootApplicationYamlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootApplicationYamlAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof YAMLFile)) {
            return;
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)file.getProject()) || !SpringBootApplicationYamlUtil.isApplicationYamlFile((YAMLFile)file)) {
            return;
        }
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
        PsiElement yamlKeyElement = yamlKeyValue.getKey();
        if (yamlKeyElement == null) {
            return;
        }
        SpringBootApplicationYamlAnnotator.annotateKey(yamlKeyValue, yamlKeyElement, holder);
        YAMLValue yamlValue = yamlKeyValue.getValue();
        if (yamlValue instanceof YAMLScalar) {
            this.annotateValue((PsiElement)yamlValue, holder);
        }
    }

    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        return YAMLHighlighter.SCALAR_KEY;
    }

    private static void annotateKey(YAMLKeyValue keyValue, PsiElement yamlKeyElement, AnnotationHolder holder) {
        String keyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(keyValue);
        if ("spring.profiles".equals(keyName)) {
            holder.createInfoAnnotation(yamlKeyElement, null).setTextAttributes(DefaultLanguageHighlighterColors.KEYWORD);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

