/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class SpringBootApplicationYamlUtil {
    static final String SPRING_PROFILES_KEY = "spring.profiles";

    static boolean isInsideApplicationYamlFile(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        PsiFile originalFile = containingFile.getOriginalFile();
        return originalFile instanceof YAMLFile && SpringBootApplicationYamlUtil.isApplicationYamlFile((YAMLFile)originalFile);
    }

    public static boolean isApplicationYamlFile(YAMLFile yamlFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)yamlFile);
        if (!SpringCommonUtils.hasSpringFacet((Module)module) || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)yamlFile, () -> {
            VirtualFile virtualFile = yamlFile.getVirtualFile();
            boolean found = false;
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                if (contributor.getFileType() != YAMLFileType.YML) continue;
                List files = contributor.getConfigurationFiles(module, true);
                found = files.contains(virtualFile);
                break;
            }
            ArrayList dependencies = ContainerUtil.newArrayList((Object[])new Object[]{yamlFile, FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID), ProjectRootManager.getInstance((Project)yamlFile.getProject())});
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet != null) {
                dependencies.add(springFacet.getConfiguration());
            }
            return CachedValueProvider.Result.create((Object)found, (Collection)dependencies);
        });
    }

    static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue) {
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        while (element != null) {
            if (builder.length() > 0) {
                builder.insert(0, '.');
            }
            builder.insert(0, element.getKeyText());
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            element = (YAMLKeyValue)parent;
        }
        return builder.toString();
    }
}

