/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.Settings;
import org.fest.swing.input.InputState;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.timing.Pause;

class AWTEventPoster {
    private final Toolkit toolkit;
    private final InputState inputState;
    private final WindowMonitor windowMonitor;
    private final Settings settings;

    AWTEventPoster(@Nonnull Toolkit toolkit, @Nonnull InputState inputState, @Nonnull WindowMonitor windowMonitor, @Nonnull Settings settings) {
        if (toolkit == null) {
            AWTEventPoster.$$$reportNull$$$0(0);
        }
        if (inputState == null) {
            AWTEventPoster.$$$reportNull$$$0(1);
        }
        if (windowMonitor == null) {
            AWTEventPoster.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AWTEventPoster.$$$reportNull$$$0(3);
        }
        this.toolkit = toolkit;
        this.inputState = inputState;
        this.windowMonitor = windowMonitor;
        this.settings = settings;
    }

    void postEvent(@Nullable Component c, @Nonnull AWTEvent event) {
        if (event == null) {
            AWTEventPoster.$$$reportNull$$$0(4);
        }
        this.inputState.update(event);
        EventQueue eventQueue = this.eventQueueFor(c);
        if (eventQueue != null) {
            eventQueue.postEvent(event);
        }
        Pause.pause(this.settings.delayBetweenEvents());
    }

    @Nullable
    private EventQueue eventQueueFor(@Nullable Component c) {
        return c != null ? this.windowMonitor.eventQueueFor(c) : this.toolkit.getSystemEventQueue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowMonitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/core/AWTEventPoster";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "postEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

